/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Constants;
import org.apache.axis.message.addressing.Relationship;
import org.apache.axis.message.addressing.util.TextExtractor;
import org.apache.axis.types.URI;

public class RelatesTo
extends Relationship {
    public RelatesTo(String uri, String type) throws URI.MalformedURIException {
        super(uri, type);
    }

    public RelatesTo(URI uri, QName type) {
        super(uri, type);
    }

    public RelatesTo(String uri, QName type) throws URI.MalformedURIException {
        super(new URI(uri), type);
    }

    public RelatesTo(SOAPElement el) throws Exception {
        this.setURI(new URI(TextExtractor.getText(el)));
        String value = el.getAttribute("RelationshipType");
        if (value != null && value.length() > 0) {
            int pos = value.indexOf(58);
            if (pos == -1) {
                this.setType(new QName(value));
            } else {
                String namespace = el.getNamespaceURI(value.substring(0, pos));
                this.setType(new QName(namespace, value.substring(pos + 1)));
            }
        } else {
            this.setType(Constants.QNAME_RESPONSE);
        }
    }

    protected SOAPHeaderElement toSOAPHeaderElement(SOAPEnvelope env, String actorURI) throws Exception {
        Name nm = env.createName("RelatesTo", "wsa", "http://schemas.xmlsoap.org/ws/2004/03/addressing");
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        SOAPHeaderElement headerElement = (SOAPHeaderElement)header.addHeaderElement(nm);
        headerElement.setActor(actorURI);
        QName type = this.getType();
        if (type != null) {
            headerElement.addAttribute("", "RelationshipType", type);
        }
        headerElement.addTextNode(this.getURI().toString());
        return headerElement;
    }
}

