/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.message.MessageElement;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.SimpleResourceProperty;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.Resources;
import org.globus.wsrf.utils.StringBufferReader;
import org.globus.wsrf.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SimpleResourcePropertySet
implements ResourcePropertySet {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    private QName name;
    private Map propertiesMap = new HashMap();
    private List propertiesList = new ArrayList();
    private boolean openContent;
    private boolean localNameMatching = false;

    public SimpleResourcePropertySet(QName name) {
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public ResourceProperty create(ResourcePropertyMetaData rpMetaData) {
        return new SimpleResourceProperty(rpMetaData);
    }

    public ResourceProperty get(QName name) {
        ResourceProperty prop = (ResourceProperty)this.propertiesMap.get(name);
        if (prop != null) {
            return prop;
        }
        if (this.localNameMatching) {
            Iterator iter = this.propertiesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                QName rp = (QName)entry.getKey();
                if (!rp.getLocalPart().equals(name.getLocalPart())) continue;
                return (ResourceProperty)entry.getValue();
            }
        }
        return null;
    }

    public boolean add(ResourceProperty property) {
        QName name = property.getMetaData().getName();
        ResourceProperty previous = this.propertiesMap.put(name, property);
        if (previous != null) {
            int pos = this.propertiesList.indexOf(previous);
            this.propertiesList.set(pos, property);
        } else {
            this.propertiesList.add(property);
        }
        return true;
    }

    public boolean remove(QName name) {
        ResourceProperty prop = (ResourceProperty)this.propertiesMap.remove(name);
        if (prop != null) {
            this.propertiesList.remove(prop);
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return this.propertiesList.iterator();
    }

    public boolean isOpenContent() {
        return this.openContent;
    }

    public void clear() {
        this.propertiesMap.clear();
        this.propertiesList.clear();
    }

    public int size() {
        return this.propertiesMap.size();
    }

    public boolean isEmpty() {
        return this.propertiesMap.isEmpty();
    }

    public void setOpenContent(boolean open) {
        this.openContent = open;
    }

    public boolean isLocalNameMatching() {
        return this.localNameMatching;
    }

    public void setLocalNameMatching(boolean matching) {
        this.localNameMatching = matching;
    }

    public Element toElement() throws SerializationException {
        return this.toElementSpecific();
    }

    protected Element toElementGeneral() throws SerializationException {
        Document doc = null;
        try {
            doc = XmlUtils.newDocument();
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("rpDocSerializationError"), e);
        }
        Element rootElement = doc.createElementNS(this.name.getNamespaceURI(), this.name.getLocalPart());
        doc.appendChild(rootElement);
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ResourceProperty prop = (ResourceProperty)iter.next();
            Element[] values = prop.toElements();
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                if (doc == values[i].getOwnerDocument()) {
                    rootElement.appendChild(values[i]);
                    continue;
                }
                rootElement.appendChild(doc.importNode(values[i], true));
            }
        }
        return rootElement;
    }

    protected Element toElementSpecific() throws SerializationException {
        StringWriter writer = new StringWriter();
        writer.write("<ns0:" + this.name.getLocalPart() + " xmlns:ns0=\"" + this.name.getNamespaceURI() + "\">");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ResourceProperty prop = (ResourceProperty)iter.next();
            SOAPElement[] values = prop.toSOAPElements();
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] instanceof MessageElement) {
                    try {
                        AnyHelper.write(writer, (MessageElement)values[i]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new SerializationException(i18n.getMessage("rpDocSerializationError"), e);
                    }
                }
                return this.toElementGeneral();
            }
        }
        writer.write("</ns0:" + this.name.getLocalPart() + ">");
        writer.flush();
        StringBufferReader reader = new StringBufferReader(writer.getBuffer());
        try {
            Document doc = XmlUtils.newDocument(new InputSource(reader));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new SerializationException(i18n.getMessage("rpDocSerializationError"), e);
        }
    }

    public SOAPElement toSOAPElement() throws SerializationException {
        MessageElement rootElement = new MessageElement(this.name.getNamespaceURI(), this.name.getLocalPart());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            ResourceProperty prop = (ResourceProperty)iter.next();
            SOAPElement[] values = prop.toSOAPElements();
            if (values == null) continue;
            try {
                for (int i = 0; i < values.length; ++i) {
                    rootElement.addChildElement(values[i]);
                }
            }
            catch (Exception e) {
                throw new SerializationException(i18n.getMessage("rpDocSerializationError"), e);
            }
        }
        return rootElement;
    }
}

