/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.util.Collection;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.state.GCUBEReadWriteLock;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.NoSuchResourceException;

public abstract class GCUBEPersistenceDelegate<RESOURCEID, RESOURCE extends GCUBEStatefulResource<RESOURCEID>> {
    protected final GCUBELog logger = new GCUBELog(this);

    public synchronized void initialise(GCUBEResourceHome<? super RESOURCEID, RESOURCEID, RESOURCE> home) throws Exception {
        this.logger.trace("initialising " + this.getClass().getSimpleName());
        this.logger.setContext(home.getServiceContext());
    }

    public void load(RESOURCE resource, boolean firstLoad) throws Exception {
        try {
            this.onLoad(resource, firstLoad);
            this.logger.trace("deserialised " + resource.getClass().getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ") [" + (firstLoad ? "HARD" : "SOFT") + "]");
        }
        catch (NoSuchResourceException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("resource " + resource.getClass().getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ") could not be deserialised", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(RESOURCE resource) {
        try {
            GCUBEReadWriteLock.GCUBEWriteLock lock = ((GCUBEStatefulResource)resource).getLock().writeLock();
            try {
                lock.lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new Exception("resource concurrently removed");
            }
            try {
                this.logger.info("serialising " + resource.getClass().getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
                this.onStore(resource);
                if (((GCUBEStatefulResource)resource).getServiceContext().getStatus() != GCUBEServiceContext.Status.FAILED) {
                    ((GCUBEStatefulResource)resource).getServiceContext().notifyStateChange();
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Exception e) {
            this.logger.warn("resource " + ((GCUBEStatefulResource)resource).getID() + " could not be serialised", e);
        }
    }

    public void remove(RESOURCE resource) {
        try {
            this.logger.info("removing serialisation of " + resource.getClass().getSimpleName() + "(" + ((GCUBEStatefulResource)resource).getID() + ")");
            this.onRemove(resource);
        }
        catch (Exception e) {
            this.logger.warn("serialisation of resource " + ((GCUBEStatefulResource)resource).getID() + " could not be removed", e);
        }
    }

    protected abstract void onLoad(RESOURCE var1, boolean var2) throws Exception;

    protected abstract void onStore(RESOURCE var1) throws Exception;

    protected abstract void onRemove(RESOURCE var1) throws Exception;

    public abstract Collection<RESOURCEID> getResourceIdentifiers();
}

