/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.utils.handlers.GCUBEServiceClient;
import org.gcube.common.core.utils.handlers.GCUBEServiceHandler;
import org.gcube.common.core.utils.handlers.GCUBEStatefulServiceHandler;

public abstract class GCUBEStagingServiceHandler<CLIENT extends GCUBEServiceClient>
extends GCUBEStatefulServiceHandler<CLIENT> {
    public GCUBEStagingServiceHandler() {
    }

    public GCUBEStagingServiceHandler(CLIENT client) {
        super(client);
    }

    @Override
    protected List<EndpointReferenceType> getInstances() throws Exception {
        try {
            return super.getInstances();
        }
        catch (GCUBEServiceHandler.NoQueryResultException ignore) {
            List<EndpointReferenceType> eprs = this.getFactories();
            EndpointReferenceType newEPR = this.tryFactories(eprs);
            return Arrays.asList(newEPR);
        }
    }

    protected EndpointReferenceType tryFactories(List<EndpointReferenceType> eprs) throws Exception {
        ArrayList<EndpointReferenceType> busyEprs;
        int attempts = 0;
        Exception lastException = null;
        do {
            busyEprs = new ArrayList<EndpointReferenceType>();
            ++attempts;
            for (EndpointReferenceType epr : eprs) {
                try {
                    this.logger.info("Trying factory of " + this.getTargetPortTypeName() + " @ " + epr);
                    return this._createInstance(epr);
                }
                catch (GCUBEUnrecoverableException e) {
                    throw e;
                }
                catch (GCUBERetrySameException e) {
                    lastException = e;
                    this.logger.info("Trying again later @ " + epr.getAddress());
                    busyEprs.add(epr);
                }
                catch (GCUBERetryEquivalentException ignoreSilent) {
                    lastException = ignoreSilent;
                    this.logger.error("Failed @ factory " + epr.getAddress() + (ignoreSilent.getMessage() == null ? "" : ":" + ignoreSilent.getMessage()));
                }
                catch (Exception ignoreLoud) {
                    lastException = ignoreLoud;
                    this.logger.error("Failed @ factory " + epr.getAddress(), ignoreLoud);
                }
            }
        } while (!(eprs = busyEprs).isEmpty() && attempts < this.getAttempts());
        throw lastException;
    }

    protected List<EndpointReferenceType> getFactories() throws Exception, GCUBEServiceHandler.NoQueryResultException {
        this.logger.info("Looking for factories of " + this.getTargetPortTypeName());
        List<EndpointReferenceType> factoryEprs = this.findFactories();
        if (factoryEprs == null || factoryEprs.size() == 0) {
            throw new GCUBEServiceHandler.NoQueryResultException();
        }
        return factoryEprs;
    }

    protected EndpointReferenceType _createInstance(EndpointReferenceType epr) throws Exception {
        this.logger.info("Creating instance of " + this.getTargetPortTypeName() + " @ " + epr.getAddress());
        try {
            return this.createInstance(epr);
        }
        catch (GCUBEFault f) {
            f.setFaultMessage("Error from factory of " + this.getTargetPortTypeName() + ":" + f.getFaultMessage());
            throw f.toException();
        }
    }

    protected abstract List<EndpointReferenceType> findFactories() throws Exception;

    protected abstract EndpointReferenceType createInstance(EndpointReferenceType var1) throws Exception;
}

