/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.common.scope.impl.DefaultServiceMap;
import org.gcube.common.scope.impl.Utils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceMapScanner {
    private static Logger log = LoggerFactory.getLogger(ServiceMapScanner.class);
    static final String mapConfigPattern = ".*\\.servicemap";

    ServiceMapScanner() {
    }

    static Map<String, ServiceMap> maps() {
        HashMap<String, ServiceMap> maps = new HashMap<String, ServiceMap>();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DefaultServiceMap.class});
            Unmarshaller um = context.createUnmarshaller();
            ConfigurationBuilder builder = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forManifest(Utils.urlsToScan())).setScanners(new Scanner[]{new ResourcesScanner()});
            Reflections reflections = new Reflections((Configuration)builder);
            for (String resource : reflections.getResources(Pattern.compile(mapConfigPattern))) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
                log.trace("loading {} ", (Object)url);
                DefaultServiceMap map = (DefaultServiceMap)um.unmarshal(url);
                maps.put(map.scope(), map);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not load service maps", e);
        }
        return maps;
    }
}

