/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import javax.net.SocketFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.znerd.xmlenc.XMLOutputter;

public class FileChecksumServlets {

    public static class GetServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            String path = ServletUtil.getDecodedPath(request, "/getFileChecksum");
            XMLOutputter xml = new XMLOutputter((Writer)out, "UTF-8");
            xml.declaration();
            final Configuration conf = new Configuration(DataNode.getDataNode().getConf());
            int socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
            SocketFactory socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
            try {
                ClientProtocol nnproxy = this.getUGI(request, conf).doAs(new PrivilegedExceptionAction<ClientProtocol>(){

                    @Override
                    public ClientProtocol run() throws IOException {
                        return DFSClient.createNamenode(conf);
                    }
                });
                MD5MD5CRC32FileChecksum checksum = DFSClient.getFileChecksum(path, nnproxy, socketFactory, socketTimeout);
                MD5MD5CRC32FileChecksum.write(xml, checksum);
            }
            catch (IOException ioe) {
                this.writeXml(ioe, path, xml);
            }
            catch (InterruptedException e) {
                this.writeXml(e, path, xml);
            }
            xml.endDocument();
        }
    }

    public static class RedirectServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        private URL createRedirectURL(UserGroupInformation ugi, DatanodeID host, HttpServletRequest request, NameNode nn) throws IOException {
            String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
            String scheme = request.getScheme();
            int port = "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort();
            String encodedPath = ServletUtil.getRawPath(request, "/fileChecksum");
            String dtParam = "";
            if (UserGroupInformation.isSecurityEnabled()) {
                String tokenString = ugi.getTokens().iterator().next().encodeToUrlString();
                dtParam = JspHelper.getDelegationTokenUrlParam(tokenString);
            }
            return new URL(scheme, hostname, port, "/getFileChecksum" + encodedPath + '?' + "ugi=" + ServletUtil.encodeQueryValue(ugi.getShortUserName()) + dtParam);
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            ServletContext context = this.getServletContext();
            Configuration conf = (Configuration)context.getAttribute("current.conf");
            UserGroupInformation ugi = this.getUGI(request, conf);
            NameNode namenode = (NameNode)context.getAttribute("name.node");
            DatanodeDescriptor datanode = namenode.namesystem.getRandomDatanode();
            try {
                response.sendRedirect(this.createRedirectURL(ugi, datanode, request, namenode).toString());
            }
            catch (IOException e) {
                response.sendError(400, e.getMessage());
            }
        }
    }
}

