/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.coding.impl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axis.encoding.Base64;
import org.gcube.contentmanagement.blobstorage.coding.IEncode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodeByteString
extends Base64
implements IEncode {
    final Logger logger = LoggerFactory.getLogger(EncodeByteString.class);

    public String convertString2Base64(String hello) {
        byte[] encoded = Base64.encode((byte[])hello.getBytes()).getBytes();
        System.out.println(Arrays.toString(encoded));
        String encodedString = new String(encoded);
        System.out.println(hello + " = " + encodedString);
        return encodedString;
    }

    public String convertBase642String(String base64) throws FileNotFoundException {
        return "";
    }

    public String decodingString(String encode) throws IOException {
        Base64 base64 = new Base64();
        byte[] decoded = null;
        try {
            decoded = Base64.decode((String)encode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getText(decoded);
    }

    @Override
    public void decodeByte2File(byte[] encode, String path, boolean isBase64) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        byte[] decode = null;
        decode = isBase64 ? EncodeByteString.decode((String)this.getText(encode)) : encode;
        try {
            ((OutputStream)out).write(decode);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("New file created! at: " + System.currentTimeMillis());
    }

    public String encodingString(String decode) throws IOException {
        byte[] encoded = null;
        try {
            encoded = Base64.encode((byte[])decode.getBytes()).getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getText(encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decodeStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encodeStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    @Override
    public byte[] encodeGenericFile(String path, boolean isChunk, boolean isBase64) {
        byte[] encode = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - start");
        }
        long start = System.currentTimeMillis();
        byte[] bytes = null;
        try {
            bytes = this.read2list(path);
        }
        catch (Exception e) {
            this.logger.error("encodeGenericFile(String, boolean, boolean)", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - bytes length: " + bytes.length);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" ***Tempo per codifica da file a byte: " + (System.currentTimeMillis() - start));
        }
        start = System.currentTimeMillis();
        encode = isBase64 ? Base64.encode((byte[])bytes).getBytes() : bytes;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("***Tempo per codifica in base64: " + (System.currentTimeMillis() - start));
        }
        return encode;
    }

    @Override
    public List encodeFileChunked(String path, boolean isChunk, int chunkDimension) {
        Object encode = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - start");
        }
        long start = System.currentTimeMillis();
        List bytesList = null;
        try {
            bytesList = this.read2list(path, chunkDimension);
        }
        catch (Exception e) {
            this.logger.error("encodeGenericFile(String, boolean, boolean)", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - bytes length: " + bytesList.size());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" ***Tempo per codifica da file a byte: " + (System.currentTimeMillis() - start));
        }
        return bytesList;
    }

    @Override
    public byte[] encodeFileChunked2(InputStream in, String path, boolean isChunk, long chunkDimension) {
        Object encode = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - start");
        }
        long start = System.currentTimeMillis();
        byte[] bytesList = null;
        try {
            bytesList = this.read2list(in, path, chunkDimension);
        }
        catch (Exception e) {
            this.logger.error("encodeGenericFile(String, boolean, boolean)", (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("encodeGenericFile(String, boolean, boolean) - bytes length: " + bytesList.length);
        }
        return bytesList;
    }

    public byte[] encodeGenericFileWithNIO(String path, boolean isChunk, int bufferSize, long offset) throws Exception {
        FileInputStream fin = new FileInputStream(path);
        FileChannel fc = fin.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        long filePosition = fc.read(buffer, offset);
        byte[] bytes = buffer.array();
        return bytes;
    }

    private byte[][] wrappedChunk2Byte(byte[] encode, int dim) {
        int temp = 0;
        int totChunks = 0;
        totChunks = encode.length > dim ? ((temp = encode.length / dim) * dim < encode.length ? encode.length / dim + 1 : encode.length / dim) : encode.length;
        byte[][] dest = new byte[totChunks][dim];
        StringBuffer chunks = new StringBuffer();
        int i = 0;
        int j = 0;
        while (i < encode.length) {
            if (i + dim < encode.length) {
                System.arraycopy(encode, i, dest[j], 0, dim);
            } else {
                System.arraycopy(encode, i, dest[j], 0, encode.length - i);
            }
            i += dim;
            ++j;
        }
        return dest;
    }

    public byte[] wrappedOneChunk2Byte(byte[] encode, int dim, int currentIndex) {
        int temp = 0;
        int totChunks = 0;
        totChunks = encode.length > dim ? ((temp = encode.length / dim) * dim < encode.length ? encode.length / dim + 1 : encode.length / dim) : encode.length;
        byte[] dest = new byte[dim];
        int i = currentIndex;
        boolean j = false;
        if (i < encode.length) {
            if (i + dim < encode.length) {
                System.arraycopy(encode, i, dest, 0, dim);
            } else {
                System.arraycopy(encode, i, dest, 0, encode.length - i);
            }
        }
        return dest;
    }

    private byte[] getBytesFromFile(String path) {
        File file = new File(path);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            this.logger.error("getBytesFromFile(String)", (Throwable)e1);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        byte[] bytes = new byte[1024];
        try {
            int readNum;
            while ((readNum = fis.read(buf)) != -1) {
                bos.write(buf, 0, readNum);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("getBytesFromFile(String) - read " + readNum + " bytes,");
                }
                bytes = bos.toByteArray();
            }
        }
        catch (IOException ex) {
            this.logger.error("getBytesFromFile(String)", (Throwable)ex);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read2array(String file) throws Exception {
        InputStream in = null;
        byte[] out = new byte[]{};
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            int bufLen = 20480000;
            byte[] buf = new byte[bufLen];
            byte[] tmp = null;
            int len = 0;
            while ((len = in.read(buf, 0, bufLen)) != -1) {
                tmp = new byte[out.length + len];
                System.arraycopy(out, 0, tmp, 0, out.length);
                System.arraycopy(buf, 0, tmp, out.length, len);
                out = tmp;
                tmp = null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read2list(String file) throws Exception {
        InputStream in = null;
        byte[] buf = null;
        int bufLen = 20480000;
        try {
            int i;
            in = new BufferedInputStream(new FileInputStream(file));
            buf = new byte[bufLen];
            byte[] tmp = null;
            int len = 0;
            ArrayList<byte[]> data = new ArrayList<byte[]>(24);
            while ((len = in.read(buf, 0, bufLen)) != -1) {
                tmp = new byte[len];
                System.arraycopy(buf, 0, tmp, 0, len);
                data.add(tmp);
            }
            len = 0;
            if (data.size() == 1) {
                byte[] byArray = (byte[])data.get(0);
                return byArray;
            }
            for (i = 0; i < data.size(); ++i) {
                len += ((byte[])data.get(i)).length;
            }
            buf = new byte[len];
            len = 0;
            for (i = 0; i < data.size(); ++i) {
                tmp = (byte[])data.get(i);
                System.arraycopy(tmp, 0, buf, len, tmp.length);
                len += tmp.length;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List read2list(String file, int chunkDimension) throws Exception {
        InputStream in = null;
        byte[] buf = null;
        int bufLen = chunkDimension;
        ArrayList<byte[]> data = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            buf = new byte[bufLen];
            byte[] tmp = null;
            int len = 0;
            data = new ArrayList<byte[]>(24);
            while ((len = in.read(buf, 0, bufLen)) != -1) {
                tmp = new byte[len];
                System.arraycopy(buf, 0, tmp, 0, len);
                data.add(tmp);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return data;
    }

    public byte[] read2list(InputStream in, String file, long chunkDimension) throws Exception {
        byte[] buf = null;
        int bufLen = (int)chunkDimension;
        byte[] data = null;
        try {
            buf = new byte[bufLen];
            int len = 0;
            len = in.read(buf, 0, bufLen);
            if (len != -1) {
                data = new byte[len];
                System.arraycopy(buf, 0, data, 0, len);
            }
        }
        catch (Exception e) {
            this.logger.error("Errore InputStream:" + e.getMessage());
            e.printStackTrace();
        }
        return data;
    }

    public String getText(byte[] arr) {
        String s = null;
        s = new String(arr);
        return s;
    }
}

