/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TransformBase64Decode
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#base64";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, TransformationException {
        return this.enginePerformTransform(xMLSignatureInput, null);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, TransformationException {
        try {
            if (xMLSignatureInput.isElement()) {
                Node node = xMLSignatureInput.getSubNode();
                if (xMLSignatureInput.getSubNode().getNodeType() == 3) {
                    node = node.getParentNode();
                }
                StringBuffer stringBuffer = new StringBuffer();
                this.traverseElement((Element)node, stringBuffer);
                if (outputStream == null) {
                    byte[] byArray = Base64.decode(stringBuffer.toString());
                    return new XMLSignatureInput(byArray);
                }
                Base64.decode(stringBuffer.toString().getBytes(), outputStream);
                XMLSignatureInput xMLSignatureInput2 = new XMLSignatureInput((byte[])null);
                xMLSignatureInput2.setOutputStream(outputStream);
                return xMLSignatureInput2;
            }
            if (xMLSignatureInput.isOctetStream() || xMLSignatureInput.isNodeSet()) {
                if (outputStream == null) {
                    byte[] byArray = xMLSignatureInput.getBytes();
                    byte[] byArray2 = Base64.decode(byArray);
                    return new XMLSignatureInput(byArray2);
                }
                if (xMLSignatureInput.isByteArray()) {
                    Base64.decode(xMLSignatureInput.getBytes(), outputStream);
                } else {
                    Base64.decode(new BufferedInputStream(xMLSignatureInput.getOctetStreamReal()), outputStream);
                }
                XMLSignatureInput xMLSignatureInput3 = new XMLSignatureInput((byte[])null);
                xMLSignatureInput3.setOutputStream(outputStream);
                return xMLSignatureInput3;
            }
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xMLSignatureInput.getOctetStream());
                Element element = document.getDocumentElement();
                StringBuffer stringBuffer = new StringBuffer();
                this.traverseElement(element, stringBuffer);
                byte[] byArray = Base64.decode(stringBuffer.toString());
                return new XMLSignatureInput(byArray);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new TransformationException("c14n.Canonicalizer.Exception", parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new TransformationException("SAX exception", sAXException);
            }
        }
        catch (Base64DecodingException base64DecodingException) {
            throw new TransformationException("Base64Decoding", base64DecodingException);
        }
    }

    void traverseElement(Element element, StringBuffer stringBuffer) {
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 1: {
                    this.traverseElement((Element)node, stringBuffer);
                    continue block4;
                }
                case 3: {
                    stringBuffer.append(((Text)node).getData());
                }
            }
        }
    }
}

