/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.utils.URI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer = ResolverXPointer.class$("org.apache.xml.security.utils.resolver.implementations.ResolverXPointer")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer).getName());
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = attr.getOwnerElement().getOwnerDocument();
        if (ResolverXPointer.isXPointerSlash(attr)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(attr) && (node = IdResolver.getElementById(document, (String)(object = ResolverXPointer.getXPointerId(attr)))) == null) {
            Object[] objectArray = new Object[]{object};
            throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
        }
        CachedXPathAPIHolder.setDoc(document);
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        try {
            URI uRI = new URI(new URI(string), attr.getNodeValue());
            ((XMLSignatureInput)object).setSourceURI(uRI.toString());
        }
        catch (URI.MalformedURIException malformedURIException) {
            ((XMLSignatureInput)object).setSourceURI(string);
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        return ResolverXPointer.isXPointerSlash(attr) || ResolverXPointer.isXPointerId(attr);
    }

    private static boolean isXPointerSlash(Attr attr) {
        return attr.getNodeValue().equals("#xpointer(/)");
    }

    private static boolean isXPointerId(Attr attr) {
        String string;
        String string2 = attr.getNodeValue();
        if (string2.startsWith("#xpointer(id(") && string2.endsWith("))") && ((string = string2.substring("#xpointer(id(".length(), string2.length() - "))".length())).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            if (log.isDebugEnabled()) {
                log.debug("Id=" + string.substring(1, string.length() - 1));
            }
            return true;
        }
        return false;
    }

    private static String getXPointerId(Attr attr) {
        String string;
        String string2 = attr.getNodeValue();
        if (string2.startsWith("#xpointer(id(") && string2.endsWith("))") && ((string = string2.substring("#xpointer(id(".length(), string2.length() - "))".length())).charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"' || string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'')) {
            return string.substring(1, string.length() - 1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

