/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class TBCPadding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "TBC";
    }

    public int addPadding(byte[] byArray, int n) {
        int n2 = byArray.length - n;
        int n3 = n > 0 ? ((byArray[n - 1] & 1) == 0 ? -1 : 0) : ((byArray[byArray.length - 1] & 1) == 0 ? -1 : 0);
        while (n < byArray.length) {
            byArray[n] = n3;
            ++n;
        }
        return n2;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        byte by = byArray[byArray.length - 1];
        int n = byArray.length - 1;
        while (n > 0 && byArray[n - 1] == by) {
            --n;
        }
        return byArray.length - n;
    }
}

