/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.utils.Resources;

public class FilePersistenceHelper {
    private static I18n i18n = I18n.getI18n(Resources.class.getName());
    public static final String SERVER_ID = "org.globus.wsrf.container.server.id";
    private static final String FILE_PERSISTENCE_DIR = FilePersistenceHelper.getPersistenceDirectory();
    private static final String PERSISTENCE_DIR_PROPERTY = "org.globus.wsrf.container.persistence.dir";
    private static Log logger = LogFactory.getLog(FilePersistenceHelper.class.getName());
    protected Class beanClass;
    protected File storageDir;
    protected String fileSuffix;

    private static String getServerID() {
        return ContainerConfig.getContainerID();
    }

    private static String getPersistenceDirectory() {
        String value = System.getProperty(PERSISTENCE_DIR_PROPERTY);
        return value == null ? System.getProperty("user.home") + File.separatorChar + ".globus" + File.separatorChar + "persisted" : value;
    }

    public static String getDefaultStorageDir(Class beanClass) throws IOException {
        if (beanClass == null) {
            return null;
        }
        String fullClassName = beanClass.getName();
        String className = fullClassName;
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            className = className.substring(pos + 1);
        }
        String dir = FILE_PERSISTENCE_DIR + File.separatorChar + FilePersistenceHelper.getServerID() + File.separatorChar + className;
        File baseDir = new File(FILE_PERSISTENCE_DIR);
        File storageDir = new File(dir);
        if (!storageDir.getCanonicalPath().startsWith(baseDir.getCanonicalPath())) {
            throw new IOException(i18n.getMessage("invalidStorageDir", dir));
        }
        return dir;
    }

    public FilePersistenceHelper(Class beanClass, String suffix) throws IOException {
        this(beanClass, FilePersistenceHelper.getDefaultStorageDir(beanClass), suffix);
    }

    public FilePersistenceHelper(Class beanClass, String storageDir, String suffix) throws IOException {
        if (beanClass == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "beanClass"));
        }
        if (storageDir == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "storageDir"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", "suffix"));
        }
        this.beanClass = beanClass;
        this.fileSuffix = suffix;
        this.setStorageDirectory(storageDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStorageDirectory(String strDir) throws IOException {
        File dir = new File(strDir);
        Class clazz = FilePersistenceHelper.class;
        synchronized (clazz) {
            if (!dir.exists()) {
                if (!dir.mkdirs()) {
                    throw new IOException(i18n.getMessage("storDirFailed", dir));
                }
            } else if (!dir.canWrite() || !dir.canRead()) {
                throw new IOException(i18n.getMessage("storDirPerm", dir));
            }
        }
        this.storageDir = dir;
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public File getKeyAsFile(Object key) {
        Object keyValue;
        if (logger.isDebugEnabled()) {
            logger.debug("Type of key is: " + key.getClass().getName());
        }
        if ((keyValue = key) instanceof ResourceKey) {
            keyValue = ((ResourceKey)key).getValue();
        }
        File file = new File(this.getStorageDirectory(), keyValue + this.fileSuffix);
        if (logger.isDebugEnabled()) {
            logger.debug("File used for persistence: " + file.getAbsolutePath());
        }
        return file;
    }

    public void remove(Object key) throws ResourceException {
        File f = this.getKeyAsFile(key);
        if (logger.isDebugEnabled()) {
            logger.debug("Deleting state file for: " + key);
        }
        f.delete();
    }

    public List list() throws IOException {
        logger.debug("Loading the list of resource keys");
        File persistenceDirectory = this.getStorageDirectory();
        File[] keyFiles = persistenceDirectory.listFiles(new Filter(this.fileSuffix));
        ArrayList<String> keyValueList = null;
        if (keyFiles != null) {
            keyValueList = new ArrayList<String>(keyFiles.length);
            for (int i = 0; i < keyFiles.length; ++i) {
                String fileName = keyFiles[i].getName();
                int keyEnd = fileName.lastIndexOf(this.fileSuffix);
                String keyValue = fileName.substring(0, keyEnd);
                keyValueList.add(keyValue);
            }
        } else {
            logger.debug("Persistence directory does not exist yet");
            keyValueList = new ArrayList(0);
        }
        return keyValueList;
    }

    public void removeAll() throws IOException {
        File persistenceDirectory = this.getStorageDirectory();
        File[] keyFiles = persistenceDirectory.listFiles(new Filter(this.fileSuffix));
        for (int i = 0; i < keyFiles.length; ++i) {
            keyFiles[i].delete();
        }
    }

    private static class Filter
    implements FilenameFilter {
        private String suffix;

        public Filter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.suffix);
        }
    }
}

