/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;

public class FileDataServlet
extends DfsServlet {
    private static JspHelper jspHelper = null;

    protected URL createRedirectURL(String path, String encodedPath, HdfsFileStatus status, UserGroupInformation ugi, ClientProtocol nnproxy, HttpServletRequest request, String dt) throws IOException {
        String scheme = request.getScheme();
        DatanodeID host = FileDataServlet.pickSrcDatanode(path, status, nnproxy);
        String hostname = host instanceof DatanodeInfo ? ((DatanodeInfo)host).getHostName() : host.getHost();
        String dtParam = "";
        if (dt != null) {
            dtParam = JspHelper.getDelegationTokenUrlParam(dt);
        }
        int port = "https".equals(scheme) ? ((Integer)this.getServletContext().getAttribute("datanode.https.port")).intValue() : host.getInfoPort();
        return new URL(scheme, hostname, port, "/streamFile" + encodedPath + '?' + "ugi=" + ServletUtil.encodeQueryValue(ugi.getShortUserName()) + dtParam);
    }

    private static DatanodeID pickSrcDatanode(String parent, HdfsFileStatus i, ClientProtocol nnproxy) throws IOException {
        if (jspHelper == null) {
            jspHelper = new JspHelper();
        }
        LocatedBlocks blks = nnproxy.getBlockLocations(i.getFullPath(new Path(parent)).toUri().getPath(), 0L, 1L);
        if (i.getLen() == 0L || blks.getLocatedBlocks().size() <= 0) {
            return jspHelper.randomNode();
        }
        return jspHelper.bestNode(blks.get(0));
    }

    public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
        final UserGroupInformation ugi = this.getUGI(request, conf);
        try {
            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClientProtocol nn = FileDataServlet.this.createNameNodeProxy();
                    String path = ServletUtil.getDecodedPath(request, "/data");
                    String encodedPath = ServletUtil.getRawPath(request, "/data");
                    String delegationToken = request.getParameter("delegation");
                    HdfsFileStatus info = nn.getFileInfo(path);
                    if (info != null && !info.isDir()) {
                        response.sendRedirect(FileDataServlet.this.createRedirectURL(path, encodedPath, info, ugi, nn, request, delegationToken).toString());
                    } else if (info == null) {
                        response.sendError(400, "File not found " + path);
                    } else {
                        response.sendError(400, path + " is a directory");
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            response.sendError(400, e.getMessage());
        }
        catch (InterruptedException e) {
            response.sendError(400, e.getMessage());
        }
    }
}

