/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.Misc;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.unidata.util.Format;

public class CoordinateAxis1D
extends CoordinateAxis {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis1D.class);
    private boolean wasRead = false;
    private boolean wasCalcRegular = false;
    private boolean wasBoundsDone = false;
    private boolean isInterval = false;
    private boolean isAscending;
    private double[] midpoint;
    private String[] names = null;
    private double[] edge;
    private double[] bound1;
    private double[] bound2;
    private boolean isRegular = false;
    private double start;
    private double increment;

    public CoordinateAxis1D(NetcdfDataset ncd, VariableDS vds) {
        super(ncd, vds);
        vds.setCaching(true);
    }

    CoordinateAxis1D(NetcdfDataset ncd, CoordinateAxis1D org) {
        super(ncd, org);
        this.orgName = org.orgName;
        this.cache = new Variable.Cache();
        org.setCaching(true);
    }

    public CoordinateAxis1D(NetcdfDataset ds, Group group, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, shortName, dataType, dims, units, desc);
    }

    public CoordinateAxis1D section(Range r) throws InvalidRangeException {
        Section section = new Section().appendRange(r);
        return (CoordinateAxis1D)this.section(section);
    }

    @Override
    protected Variable copy() {
        return new CoordinateAxis1D(this.ncd, this);
    }

    @Override
    public CoordinateAxis copyNoCache() {
        CoordinateAxis1D axis = new CoordinateAxis1D(this.ncd, this.getParentGroup(), this.getShortName(), this.getDataType(), this.getDimensionsString(), this.getUnitsString(), this.getDescription());
        axis.axisType = this.axisType;
        axis.boundaryRef = this.boundaryRef;
        axis.isContiguous = this.isContiguous;
        axis.positive = this.positive;
        axis.cache = new Variable.Cache();
        return axis;
    }

    public String getCoordName(int index) {
        if (!this.wasRead) {
            this.doRead();
        }
        if (this.isNumeric()) {
            return Format.d(this.getCoordValue(index), 5, 8);
        }
        return this.names[index];
    }

    public double getCoordValue(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return this.midpoint[index];
    }

    @Override
    public double getMinValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.min(this.midpoint[0], this.midpoint[(int)this.getSize() - 1]);
    }

    @Override
    public double getMaxValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.max(this.midpoint[0], this.midpoint[(int)this.getSize() - 1]);
    }

    public double getCoordEdge(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdge() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.edge[index];
    }

    public double[] getCoordValues() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValues() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.midpoint.clone();
    }

    public double[] getCoordEdges() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdges() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return (double[])this.edge.clone();
    }

    @Override
    public boolean isContiguous() {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.isContiguous;
    }

    public boolean isInterval() {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.isInterval;
    }

    public double[] getBound1() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound1() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        if (this.bound1 == null) {
            this.makeBoundsFromEdges();
        }
        return (double[])this.bound1.clone();
    }

    public double[] getBound2() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound2() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        if (this.bound2 == null) {
            this.makeBoundsFromEdges();
        }
        return (double[])this.bound2.clone();
    }

    public double[] getCoordEdges(int i) {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        if (!this.isContiguous()) {
            this.makeBoundsFromEdges();
        }
        double[] e = new double[2];
        if (this.isContiguous()) {
            e[0] = this.getCoordEdge(i);
            e[1] = this.getCoordEdge(i + 1);
        } else {
            e[0] = this.bound1[i];
            e[1] = this.bound2[i];
        }
        return e;
    }

    public int findCoordElement(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, false);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, false);
        }
        return this.findCoordElementNonContiguous(coordVal, false);
    }

    public int findCoordElementBounded(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElementBounded() on non-numeric");
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, true);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, true);
        }
        return this.findCoordElementNonContiguous(coordVal, true);
    }

    public int findCoordElement(double coordVal, int lastIndex) {
        return this.findCoordElement(coordVal);
    }

    private int findCoordElementRegular(double coordValue, boolean bounded) {
        int n = (int)this.getSize();
        double distance = coordValue - this.start;
        double exactNumSteps = distance / this.increment;
        int index = (int)Math.round(exactNumSteps);
        if (index < 0) {
            return bounded ? 0 : -1;
        }
        if (index >= n) {
            return bounded ? n - 1 : -1;
        }
        return index;
    }

    private boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        while (lon < lonBeg) {
            lon += 360.0;
        }
        return lon >= lonBeg && lon <= lonEnd;
    }

    private int findCoordElementIrregular(double target, boolean bounded) {
        int n = (int)this.getSize();
        int low = 0;
        int high = n;
        if (this.isAscending) {
            if (target < this.edge[low]) {
                return bounded ? 0 : -1;
            }
            if (target > this.edge[high]) {
                return bounded ? n - 1 : -1;
            }
            int mid = low;
            while (high > low + 1) {
                mid = (low + high) / 2;
                double midVal = this.edge[mid];
                if (midVal == target) {
                    return mid;
                }
                if (midVal < target) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return low;
        }
        if (target > this.edge[low]) {
            return bounded ? 0 : -1;
        }
        if (target < this.edge[high]) {
            return bounded ? n - 1 : -1;
        }
        int mid = low;
        while (high > low + 1) {
            mid = (low + high) / 2;
            double midVal = this.edge[mid];
            if (midVal == target) {
                return mid;
            }
            if (midVal < target) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return high - 1;
    }

    private int findCoordElementNonContiguous(double target, boolean bounded) {
        double[] bounds1 = this.getBound1();
        double[] bounds2 = this.getBound2();
        int n = bounds1.length;
        if (this.isAscending) {
            if (target < bounds1[0]) {
                return bounded ? 0 : -1;
            }
            if (target > bounds2[n - 1]) {
                return bounded ? n - 1 : -1;
            }
            for (int i = 0; i < n; ++i) {
                if (this.bound1[i] <= target && target <= this.bound2[i]) {
                    return i;
                }
                if (!(this.bound1[i] > target)) continue;
                if (!bounded) {
                    return -1;
                }
                double d1 = this.bound1[i] - target;
                double d2 = target - this.bound1[i - 1];
                return d1 > d2 ? i - 1 : i;
            }
            return bounded ? n - 1 : -1;
        }
        if (target > bounds1[0]) {
            return bounded ? 0 : -1;
        }
        if (target < bounds2[n - 1]) {
            return bounded ? n - 1 : -1;
        }
        for (int i = 0; i < n; ++i) {
            if (this.bound2[i] <= target && target <= this.bound1[i]) {
                return i;
            }
            if (!(this.bound2[i] < target)) continue;
            if (!bounded) {
                return -1;
            }
            double d1 = this.bound2[i] - target;
            double d2 = target - this.bound2[i - 1];
            return d1 > d2 ? i - 1 : i;
        }
        return bounded ? n - 1 : -1;
    }

    public double getStart() {
        this.calcIsRegular();
        return this.start;
    }

    public double getIncrement() {
        this.calcIsRegular();
        return this.increment;
    }

    public boolean isRegular() {
        this.calcIsRegular();
        return this.isRegular;
    }

    private void calcIsRegular() {
        if (this.wasCalcRegular) {
            return;
        }
        if (!this.wasRead) {
            this.doRead();
        }
        if (!this.isNumeric()) {
            this.isRegular = false;
        } else if (this.getSize() < 2L) {
            this.isRegular = true;
        } else {
            this.start = this.getCoordValue(0);
            int n = (int)this.getSize();
            this.increment = (this.getCoordValue(n - 1) - this.getCoordValue(0)) / (double)(n - 1);
            this.isRegular = true;
            int i = 1;
            while ((long)i < this.getSize()) {
                if (!Misc.closeEnough(this.getCoordValue(i) - this.getCoordValue(i - 1), this.increment, 0.005)) {
                    this.isRegular = false;
                    break;
                }
                ++i;
            }
        }
        this.wasCalcRegular = true;
    }

    private void doRead() {
        if (this.isNumeric()) {
            this.readValues();
            this.wasRead = true;
            if (this.getSize() < 2L) {
                this.isAscending = true;
            } else {
                boolean bl = this.isAscending = this.getCoordValue(0) < this.getCoordValue(1);
            }
            if (this.axisType == AxisType.Lon) {
                boolean monotonic = true;
                for (int i = 0; i < this.midpoint.length - 1; ++i) {
                    monotonic &= this.isAscending ? this.midpoint[i] < this.midpoint[i + 1] : this.midpoint[i] > this.midpoint[i + 1];
                }
                if (!monotonic) {
                    int i;
                    boolean cross = false;
                    if (this.isAscending) {
                        for (i = 0; i < this.midpoint.length; ++i) {
                            if (cross) {
                                int n = i;
                                this.midpoint[n] = this.midpoint[n] + 360.0;
                            }
                            if (cross || i >= this.midpoint.length - 1 || !(this.midpoint[i] > this.midpoint[i + 1])) continue;
                            cross = true;
                        }
                    } else {
                        for (i = 0; i < this.midpoint.length; ++i) {
                            if (cross) {
                                int n = i;
                                this.midpoint[n] = this.midpoint[n] - 360.0;
                            }
                            if (cross || i >= this.midpoint.length - 1 || !(this.midpoint[i] < this.midpoint[i + 1])) continue;
                            cross = true;
                        }
                    }
                    Array cachedData = Array.factory(DataType.DOUBLE, this.getShape(), (Object)this.midpoint);
                    if (this.getDataType() != DataType.DOUBLE) {
                        cachedData = MAMath.convert(cachedData, this.getDataType());
                    }
                    this.setCachedData(cachedData);
                }
            }
        } else if (this.getDataType() == DataType.STRING) {
            this.readStringValues();
            this.wasRead = true;
        } else {
            this.readCharValues();
            this.wasRead = true;
        }
    }

    private void readStringValues() {
        Array data;
        int count = 0;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading string coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        this.names = new String[(int)data.getSize()];
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            this.names[count++] = (String)ii.getObjectNext();
        }
    }

    private void readCharValues() {
        ArrayChar data;
        int count = 0;
        try {
            data = (ArrayChar)this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading char coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        ArrayChar.StringIterator iter = data.getStringIterator();
        this.names = new String[iter.getNumElems()];
        while (iter.hasNext()) {
            this.names[count++] = iter.next();
        }
    }

    private void readValues() {
        Array data;
        this.midpoint = new double[(int)this.getSize()];
        int count = 0;
        try {
            this.setUseNaNs(false);
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            this.midpoint[count++] = iter.getDoubleNext();
        }
    }

    private void makeBounds() {
        if (!this.wasRead) {
            this.doRead();
        }
        if (this.isNumeric() && !this.makeBoundsFromAux()) {
            this.makeEdges();
        }
        this.wasBoundsDone = true;
    }

    private boolean makeBoundsFromAux() {
        int i;
        Array data;
        Attribute boundsAtt = this.findAttributeIgnoreCase("bounds");
        if (null == boundsAtt || !boundsAtt.isString()) {
            return false;
        }
        String boundsVarName = boundsAtt.getStringValue();
        VariableDS boundsVar = (VariableDS)this.ncd.findVariable(boundsVarName);
        if (null == boundsVar) {
            return false;
        }
        if (2 != boundsVar.getRank()) {
            return false;
        }
        if (this.getDimension(0) != boundsVar.getDimension(0)) {
            return false;
        }
        if (2 != boundsVar.getDimension(1).getLength()) {
            return false;
        }
        try {
            boundsVar.setUseNaNs(false);
            data = boundsVar.read();
        }
        catch (IOException e) {
            log.warn("CoordinateAxis1D.hasBounds read failed ", (Throwable)e);
            return false;
        }
        assert (data.getRank() == 2 && data.getShape()[1] == 2) : "incorrect shape data for variable " + boundsVar;
        int n = this.shape[0];
        double[] value1 = new double[n];
        double[] value2 = new double[n];
        Index ima = data.getIndex();
        for (int i2 = 0; i2 < n; ++i2) {
            ima.set0(i2);
            value1[i2] = data.getDouble(ima.set1(0));
            value2[i2] = data.getDouble(ima.set1(1));
        }
        boolean goesUp = n < 2 || value1[n - 1] > value1[0];
        boolean firstLower = true;
        for (int i3 = 0; i3 < value1.length; ++i3) {
            if (value1[i3] == value2[i3]) continue;
            firstLower = value1[i3] < value2[i3];
            break;
        }
        if (goesUp != firstLower) {
            double[] temp = value1;
            value1 = value2;
            value2 = temp;
        }
        boolean contig = true;
        for (i = 0; i < n - 1; ++i) {
            if (Misc.closeEnough(value1[i + 1], value2[i])) continue;
            contig = false;
        }
        if (contig) {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n + 1; ++i) {
                this.edge[i] = value2[i - 1];
            }
        } else {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n; ++i) {
                this.edge[i] = (value1[i] + value2[i - 1]) / 2.0;
            }
            this.edge[n] = value2[n - 1];
            this.isContiguous = false;
        }
        this.bound1 = value1;
        this.bound2 = value2;
        this.isInterval = true;
        return true;
    }

    private void makeEdges() {
        int size = (int)this.getSize();
        this.edge = new double[size + 1];
        if (size < 1) {
            return;
        }
        for (int i = 1; i < size; ++i) {
            this.edge[i] = (this.midpoint[i - 1] + this.midpoint[i]) / 2.0;
        }
        this.edge[0] = this.midpoint[0] - (this.edge[1] - this.midpoint[0]);
        this.edge[size] = this.midpoint[size - 1] + (this.midpoint[size - 1] - this.edge[size - 1]);
    }

    private void makeMidpoints() {
        int size = (int)this.getSize();
        this.midpoint = new double[size];
        for (int i = 0; i < size; ++i) {
            this.midpoint[i] = (this.edge[i] + this.edge[i + 1]) / 2.0;
        }
    }

    private void makeBoundsFromEdges() {
        int size = (int)this.getSize();
        if (size == 0) {
            return;
        }
        this.bound1 = new double[size];
        this.bound2 = new double[size];
        for (int i = 0; i < size; ++i) {
            this.bound1[i] = this.edge[i];
            this.bound2[i] = this.edge[i + 1];
        }
        if (this.bound1[0] > this.bound2[0]) {
            double[] temp = this.bound1;
            this.bound1 = this.bound2;
            this.bound2 = temp;
        }
    }

    public List<NamedObject> getNames() {
        int n = (int)this.getSize();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(n);
        for (int i = 0; i < n; ++i) {
            names.add(new NamedAnything(this.getCoordName(i), this.getUnitsString()));
        }
        return names;
    }
}

