/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.StationTimeSeriesCollectionFlattened;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationTimeSeriesCollectionImpl
extends OneNestedPointCollectionImpl
implements StationTimeSeriesFeatureCollection {
    protected StationHelper stationHelper;
    protected PointFeatureCollectionIterator localIterator;

    public StationTimeSeriesCollectionImpl(String name) {
        super(name, FeatureType.STATION);
    }

    protected abstract void initStationHelper();

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
        this.initStationHelper();
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = StationTimeSeriesCollectionImpl.this.stationHelper.getStations().iterator();
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() throws IOException {
                return (PointFeatureCollection)((Object)this.stationIter.next());
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
            }
        };
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return (StationTimeSeriesFeature)s;
    }

    @Override
    public Station getStation(PointFeature feature) throws IOException {
        StationPointFeature stationFeature = (StationPointFeature)feature;
        return stationFeature.getStation();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return this.subset(this.getStations(boundingBox));
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        return new StationTimeSeriesCollectionSubset(this, stations);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, DateRange dateRange, List<VariableSimpleIF> varList) throws IOException {
        if (stations == null || stations.size() == 0) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        this.initStationHelper();
        List<Station> subsetStations = this.stationHelper.getStations(stations);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, DateRange dateRange) throws IOException {
        if (boundingBox == null) {
            return new StationTimeSeriesCollectionFlattened(this, dateRange);
        }
        this.initStationHelper();
        List<Station> subsetStations = this.stationHelper.getStations(boundingBox);
        return new StationTimeSeriesCollectionFlattened(new StationTimeSeriesCollectionSubset(this, subsetStations), dateRange);
    }

    @Override
    public List<Station> getStations() {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations();
    }

    @Override
    public List<Station> getStations(List<String> stnNames) {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations(stnNames);
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.stationHelper == null) {
            this.initStationHelper();
        }
        return this.stationHelper.getBoundingBox();
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationFeatureCollection does not implement getNestedPointFeatureCollection()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public void finish() {
        if (this.localIterator != null) {
            this.localIterator.finish();
        }
    }

    @Override
    public StationTimeSeriesFeature next() throws IOException {
        return (StationTimeSeriesFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator(-1);
    }

    private class StationTimeSeriesCollectionSubset
    extends StationTimeSeriesCollectionImpl {
        StationTimeSeriesCollectionImpl from;

        StationTimeSeriesCollectionSubset(StationTimeSeriesCollectionImpl from, List<Station> stations) {
            super(from.getName());
            this.from = from;
            this.stationHelper = new StationHelper();
            this.stationHelper.setStations(stations);
        }

        @Override
        protected void initStationHelper() {
        }
    }
}

