/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.netcdf3;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutRegularSegmented;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;

public abstract class N3iosp
extends AbstractIOServiceProvider
implements IOServiceProviderWriter {
    private static Logger log = LoggerFactory.getLogger(N3iosp.class);
    public static final byte NC_FILL_BYTE = -127;
    public static final char NC_FILL_CHAR = '\u0000';
    public static final short NC_FILL_SHORT = -32767;
    public static final int NC_FILL_INT = -2147483647;
    public static final long NC_FILL_LONG = -9223372036854775806L;
    public static final float NC_FILL_FLOAT = 9.96921E36f;
    public static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    public static final String FillValue = "_FillValue";
    public static final long MAX_VARSIZE = 0xFFFFFFFCL;
    public static final int MAX_NUMRECS = Integer.MAX_VALUE;
    private static boolean syncExtendOnly = false;
    private static final Pattern objectNamePattern = Pattern.compile("[a-zA-Z0-9_][a-zA-Z0-9_@\\:\\(\\)\\.\\-\\+]*");
    protected NetcdfFile ncfile;
    protected boolean readonly;
    protected N3header header;
    protected long lastModified;
    protected boolean debug = false;
    protected boolean debugSize = false;
    protected boolean debugSPIO = false;
    protected boolean debugRecord = false;
    protected boolean debugSync = false;
    protected boolean showHeaderBytes = false;
    protected boolean useRecordStructure;
    protected boolean fill = true;
    protected HashMap dimHash = new HashMap(50);

    public static void setProperty(String name, String value) {
        if (name.equalsIgnoreCase("syncExtendOnly")) {
            syncExtendOnly = value.equalsIgnoreCase("true");
        }
    }

    public static String makeValidNetcdfObjectName(String name) {
        char c;
        StringBuilder sb = new StringBuilder(name.trim());
        while (sb.length() > 0 && !Character.isLetter(c = sb.charAt(0)) && !Character.isDigit(c) && c != '_') {
            sb.deleteCharAt(0);
        }
        for (int pos = 1; pos < sb.length(); ++pos) {
            int c2 = sb.codePointAt(pos);
            if ((c2 < 0 || c2 >= 32) && c2 != 127) continue;
            sb.delete(pos, pos + 1);
            --pos;
        }
        if (sb.length() == 0) {
            throw new IllegalArgumentException("Illegal name");
        }
        return sb.toString();
    }

    public static String makeValidNetcdfObjectNameOld(String name) {
        char c;
        StringBuilder sb = new StringBuilder(name);
        while (sb.length() > 0 && !Character.isLetter(c = sb.charAt(0)) && c != '_') {
            if (Character.isDigit(c)) {
                sb.insert(0, 'N');
                break;
            }
            sb.deleteCharAt(0);
        }
        for (int i = 1; i < sb.length(); ++i) {
            boolean ok;
            char c2 = sb.charAt(i);
            if (c2 == ' ') {
                sb.setCharAt(i, '_');
                continue;
            }
            boolean bl = ok = Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_';
            if (ok) continue;
            sb.delete(i, i + 1);
            --i;
        }
        return sb.toString();
    }

    public static boolean isValidNetcdf3ObjectName(String name) {
        Matcher m = objectNamePattern.matcher(name);
        return m.matches();
    }

    public static Pattern getValidNetcdf3ObjectNamePattern() {
        return objectNamePattern;
    }

    public static String createValidNetcdf3ObjectName(String name) {
        char c;
        StringBuilder sb = new StringBuilder(name);
        while (sb.length() > 0 && !Character.isLetter(c = sb.charAt(0)) && c != '_') {
            if (Character.isDigit(c)) {
                sb.insert(0, 'N');
                break;
            }
            sb.deleteCharAt(0);
        }
        for (int i = 1; i < sb.length(); ++i) {
            boolean ok;
            char c2 = sb.charAt(i);
            if (c2 == ' ') {
                sb.setCharAt(i, '_');
                continue;
            }
            boolean bl = ok = Character.isLetterOrDigit(c2) || c2 == '-' || c2 == '_' || c2 == '@' || c2 == ':' || c2 == '(' || c2 == ')' || c2 == '+' || c2 == '.';
            if (ok) continue;
            sb.delete(i, i + 1);
            --i;
        }
        return sb.toString();
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return N3header.isValidFile(raf);
    }

    @Override
    public String getDetailInfo() {
        try {
            Formatter fout = new Formatter();
            double size = (double)this.raf.length() / 1000000.0;
            fout.format(" raf = %s%n", this.raf.getLocation());
            fout.format(" size= %d (%s Mb)%n%n", this.raf.length(), Format.dfrac(size, 3));
            this.header.showDetail(fout);
            return fout.toString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        File file;
        this.raf = raf;
        this.ncfile = ncfile;
        String location = raf.getLocation();
        if (!location.startsWith("http:") && (file = new File(location)).exists()) {
            this.lastModified = file.lastModified();
        }
        raf.order(0);
        this.header = new N3header();
        this.header.read(raf, ncfile, null);
        this._open(raf);
        ncfile.finish();
    }

    @Override
    public void setFill(boolean fill) {
        this.fill = fill;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Layout layout;
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout2 = layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        if (layout.getTotalNelems() == 0L) {
            return Array.factory(dataType.getPrimitiveClassType(), section.getShape());
        }
        Object data = this.readData(layout, dataType);
        return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
    }

    private Array readRecordData(Structure s, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        StructureMembers members = s.makeStructureMembers();
        for (StructureMembers.Member m : members.getMembers()) {
            Variable v2 = s.findVariable(m.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m.setDataParam((int)(vinfo.begin - this.header.recStart));
        }
        if (this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cant read records when recsize > 2147483647");
        }
        long nrecs = section.computeSize();
        if (nrecs * this.header.recsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large read: nrecs * recsize= " + nrecs * this.header.recsize + "bytes exceeds " + Integer.MAX_VALUE);
        }
        members.setStructureSize((int)this.header.recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, new int[]{recordRange.length()});
        byte[] result = structureArray.getByteBuffer().array();
        int count = 0;
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            if (recnum != this.header.numrecs - 1) {
                this.raf.readFully(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            } else {
                this.raf.read(result, (int)((long)count * this.header.recsize), (int)this.header.recsize);
            }
            ++count;
        }
        return structureArray;
    }

    private Array readRecordDataSubset(Structure s, Section section) throws IOException {
        Range recordRange = section.getRange(0);
        int nrecords = recordRange.length();
        StructureMembers members = s.makeStructureMembers();
        for (StructureMembers.Member m : members.getMembers()) {
            Variable v2 = s.findVariable(m.getName());
            N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
            m.setDataParam((int)(vinfo.begin - this.header.recStart));
            int rank = m.getShape().length;
            int[] fullShape = new int[rank + 1];
            fullShape[0] = nrecords;
            System.arraycopy(m.getShape(), 0, fullShape, 1, rank);
            Array data = Array.factory(m.getDataType(), fullShape);
            m.setDataArray(data);
            m.setDataObject(data.getIndexIterator());
        }
        return null;
    }

    public Array readNestedData(Variable v2, Section section) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        int[] fullShape = new int[v2.getRank() + 1];
        fullShape[0] = this.header.numrecs;
        System.arraycopy(v2.getShape(), 0, fullShape, 1, v2.getRank());
        LayoutRegularSegmented layout = new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, fullShape, section);
        Object dataObject = this.readData(layout, dataType);
        return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), dataObject);
    }

    @Override
    public long readToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        if (v2 instanceof Structure) {
            return this.readRecordData((Structure)v2, section, channel);
        }
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
        return this.readData(layout, dataType, channel);
    }

    private long readRecordData(Structure s, Section section, WritableByteChannel out) throws IOException, InvalidRangeException {
        long count = 0L;
        Range recordRange = section.getRange(0);
        int stride = recordRange.stride();
        if (stride == 1) {
            int first = recordRange.first();
            int n = recordRange.length();
            return this.raf.readToByteChannel(out, this.header.recStart + (long)first * this.header.recsize, (long)n * this.header.recsize);
        }
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            if (this.debugRecord) {
                System.out.println(" read record " + recnum);
            }
            this.raf.seek(this.header.recStart + (long)recnum * this.header.recsize);
            count += this.raf.readToByteChannel(out, this.header.recStart + (long)recnum * this.header.recsize, this.header.recsize);
        }
        return count;
    }

    protected static char[] convertByteToCharUTF(byte[] byteArray) {
        Charset c = Charset.forName("UTF-8");
        CharBuffer output = c.decode(ByteBuffer.wrap(byteArray));
        return output.array();
    }

    protected static byte[] convertCharToByteUTF(char[] from) {
        Charset c = Charset.forName("UTF-8");
        ByteBuffer output = c.encode(CharBuffer.wrap(from));
        return output.array();
    }

    @Override
    public void create(String filename, NetcdfFile ncfile, int extra, long preallocateSize, boolean largeFile) throws IOException {
        this.ncfile = ncfile;
        this.readonly = false;
        ncfile.finish();
        this.raf = new RandomAccessFile(filename, "rw");
        this.raf.order(0);
        if (preallocateSize > 0L) {
            java.io.RandomAccessFile myRaf = this.raf.getRandomAccessFile();
            myRaf.setLength(preallocateSize);
        }
        this.header = new N3header();
        this.header.create(this.raf, ncfile, extra, largeFile, null);
        this._create(this.raf);
        if (this.fill) {
            this.fillNonRecordVariables();
        }
    }

    @Override
    public boolean rewriteHeader(boolean largeFile) throws IOException {
        return this.header.rewriteHeader(largeFile, null);
    }

    @Override
    public void writeData(Variable v2, Section section, Array values) throws IOException, InvalidRangeException {
        N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (v2.isUnlimited()) {
            Range firstRange = section.getRange(0);
            this.setNumrecs(firstRange.last() + 1);
        }
        if (v2 instanceof Structure) {
            this.writeRecordData((Structure)v2, section, values);
        } else {
            Layout layout = !v2.isUnlimited() ? new LayoutRegular(vinfo.begin, v2.getElementSize(), v2.getShape(), section) : new LayoutRegularSegmented(vinfo.begin, v2.getElementSize(), this.header.recsize, v2.getShape(), section);
            this.writeData(values, layout, dataType);
        }
    }

    private void writeRecordData(Structure s, Section section, Array values) throws IOException, InvalidRangeException {
        if (!(values instanceof ArrayStructure)) {
            throw new IllegalArgumentException("writeRecordData: data must be ArrayStructure");
        }
        ArrayStructure structureData = (ArrayStructure)values;
        List<Variable> vars = s.getVariables();
        StructureMembers members = structureData.getStructureMembers();
        Range recordRange = section.getRange(0);
        int count = 0;
        for (int recnum = recordRange.first(); recnum <= recordRange.last(); recnum += recordRange.stride()) {
            for (Variable v2 : vars) {
                StructureMembers.Member m = members.findMember(v2.getShortName());
                if (null == m) continue;
                N3header.Vinfo vinfo = (N3header.Vinfo)v2.getSPobject();
                long begin = vinfo.begin + (long)recnum * this.header.recsize;
                LayoutRegular layout = new LayoutRegular(begin, v2.getElementSize(), v2.getShape(), v2.getShapeAsSection());
                Array data = structureData.getArray(count, m);
                this.writeData(data, layout, v2.getDataType());
            }
            ++count;
        }
    }

    protected void setNumrecs(int n) throws IOException, InvalidRangeException {
        if (n <= this.header.numrecs) {
            return;
        }
        int startRec = this.header.numrecs;
        if (this.debugSize) {
            System.out.println("extend records to = " + n);
        }
        this.header.setNumrecs(n);
        for (Dimension dim : this.ncfile.getDimensions()) {
            if (!dim.isUnlimited()) continue;
            dim.setLength(n);
        }
        for (Variable v : this.ncfile.getVariables()) {
            if (!v.isUnlimited()) continue;
            v.resetShape();
            v.setCachedData(null, false);
        }
        if (this.fill) {
            this.fillRecordVariables(startRec, n);
        } else {
            this.raf.setMinLength(this.header.calcFileSize());
        }
    }

    @Override
    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.header.updateAttribute(v2, att);
    }

    protected void fillNonRecordVariables() throws IOException {
        for (Variable v : this.ncfile.getVariables()) {
            if (v.isUnlimited()) continue;
            try {
                this.writeData(v, v.getShapeAsSection(), this.makeConstantArray(v));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
    }

    protected void fillRecordVariables(int recStart, int recEnd) throws IOException, InvalidRangeException {
        for (int i = recStart; i < recEnd; ++i) {
            Range r = new Range(i, i);
            for (Variable v : this.ncfile.getVariables()) {
                if (!v.isUnlimited() || v instanceof Structure) continue;
                Section recordSection = new Section(v.getRanges());
                recordSection.setRange(0, r);
                this.writeData(v, recordSection, this.makeConstantArray(v));
            }
        }
    }

    private Array makeConstantArray(Variable v) {
        Class classType = v.getDataType().getPrimitiveClassType();
        Attribute att = v.findAttribute(FillValue);
        Object[] storage = null;
        if (classType == Double.TYPE) {
            double[] storageP = new double[]{att == null ? (double)9.96921E36f : att.getNumericValue().doubleValue()};
            storage = storageP;
        } else if (classType == Float.TYPE) {
            float[] storageP = new float[]{att == null ? 9.96921E36f : att.getNumericValue().floatValue()};
            storage = storageP;
        } else if (classType == Integer.TYPE) {
            int[] storageP = new int[]{att == null ? -2147483647 : att.getNumericValue().intValue()};
            storage = storageP;
        } else if (classType == Short.TYPE) {
            short[] storageP = new short[]{att == null ? (short)-32767 : (short)att.getNumericValue().shortValue()};
            storage = storageP;
        } else if (classType == Byte.TYPE) {
            byte[] storageP = new byte[]{att == null ? (byte)-127 : (byte)att.getNumericValue().byteValue()};
            storage = storageP;
        } else if (classType == Character.TYPE) {
            char[] storageP = new char[]{att != null && att.getStringValue().length() > 0 ? att.getStringValue().charAt(0) : (char)'\u0000'};
            storage = storageP;
        }
        return Array.factoryConstant(classType, v.getShape(), storage);
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean result = this.header.synchNumrecs();
        if (result && log.isDebugEnabled()) {
            log.debug(" N3iosp syncExtend " + this.raf.getLocation() + " numrecs =" + this.header.numrecs);
        }
        return result;
    }

    @Override
    public boolean sync() throws IOException {
        if (syncExtendOnly) {
            return this.syncExtend();
        }
        if (this.lastModified == 0L) {
            return false;
        }
        File file = new File(this.raf.getLocation());
        if (file.exists()) {
            long currentModified = file.lastModified();
            if (currentModified == this.lastModified) {
                return false;
            }
            this.ncfile.empty();
            this.open(this.raf, this.ncfile, null);
            if (log.isDebugEnabled()) {
                log.debug(" N3iosp resynced " + this.raf.getLocation() + " currentModified=" + currentModified + " lastModified= " + this.lastModified);
            }
            return true;
        }
        throw new IOException("File does not exist");
    }

    @Override
    public void flush() throws IOException {
        this.raf.flush();
        this.header.writeNumrecs();
        this.raf.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            long size = this.header.calcFileSize();
            this.raf.setMinLength(size);
            this.raf.close();
        }
        this.raf = null;
    }

    @Override
    public String toStringDebug(Object o) {
        return null;
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (null == this.header) {
            return null;
        }
        if (message == "AddRecordStructure") {
            return this.header.makeRecordStructure();
        }
        if (message == "RemoveRecordStructure") {
            return this.header.removeRecordStructure();
        }
        return super.sendIospMessage(message);
    }

    @Override
    public String getFileTypeId() {
        return "netCDF";
    }

    @Override
    public String getFileTypeDescription() {
        return "NetCDF classic format";
    }

    protected abstract Object readData(Layout var1, DataType var2) throws IOException;

    protected abstract long readData(Layout var1, DataType var2, WritableByteChannel var3) throws IOException;

    protected abstract void writeData(Array var1, Layout var2, DataType var3) throws IOException;

    protected abstract void _open(RandomAccessFile var1) throws IOException;

    protected abstract void _create(RandomAccessFile var1) throws IOException;
}

