/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import java.awt.geom.Point2D;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class VTIBathymetry {
    private String filename;
    private String mode;
    private Point2D.Double[] points;
    private NetcdfFile ncFile;
    private Variable var;
    public boolean debug = false;
    public final int GRID_COLS = 43200;
    public final int GRID_ROWS = 21600;

    public static void main(String[] args) {
        try {
            VTIBathymetry bm = new VTIBathymetry(args[0]);
            bm.get(Double.parseDouble(args[1]), Double.parseDouble(args[2]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main_old(String[] args) {
        int status = 0;
        VTIBathymetry bm = new VTIBathymetry();
        try {
            if (!bm.parseArguments(args)) {
                System.exit(1);
            }
            bm.open();
            short[][] res = new short[361][181];
            if (bm.mode.compareTo("draw") == 0) {
                bm.draw();
            } else if (bm.mode.compareTo("get") == 0) {
                bm.debug = false;
                if (bm.points == null || bm.points.length == 0) {
                    System.err.println("No point specified");
                    System.exit(1);
                } else if (bm.points.length == 1) {
                    short z = bm.getZ(bm.points[0]);
                    if (bm.debug) {
                        System.out.println(z);
                    }
                } else {
                    short[] zs = bm.getZ(bm.points);
                    if (bm.debug) {
                        for (int i = 0; i < zs.length; ++i) {
                            System.out.println(zs[i]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR: " + e.getMessage());
            status = 1;
        }
        finally {
            try {
                bm.close();
            }
            catch (Exception exception) {}
        }
        System.exit(status);
    }

    public short get(Double x, Double y) throws IOException {
        short res = 0;
        this.debug = false;
        this.points = new Point2D.Double[1];
        this.points[0] = new Point2D.Double();
        this.points[0].setLocation(x, y);
        if (this.points == null || this.points.length == 0) {
            System.err.println("No point specified");
            System.exit(1);
        } else if (this.points.length == 1) {
            short z = this.getZ(this.points[0]);
            if (this.debug) {
                System.out.println(z);
            }
            res = z;
        } else {
            short[] zs = this.getZ(this.points);
            for (int i = 0; i < zs.length; ++i) {
                if (this.debug) {
                    System.out.println(zs[i]);
                }
                res = zs[i];
            }
        }
        return res;
    }

    private static void printUsage() {
        System.out.println("Usage: org.d4science2.vtivre.VTIBathymetry (get x,y [x2,y2 [x3,y3 ...]]) file");
        System.out.println();
        System.exit(1);
    }

    private VTIBathymetry() {
    }

    private boolean parseArguments(String[] args) throws Exception {
        try {
            if (args.length >= 1) {
                this.mode = args[0];
            }
            if (args.length >= 2) {
                this.filename = args[args.length - 1];
            }
            this.points = new Point2D.Double[args.length > 2 ? args.length - 2 : 0];
            for (int i = 0; i < args.length - 2; i = (int)((byte)(i + 1))) {
                String[] s = args[i + 1].split(",");
                if (s.length != 2) {
                    System.err.println("Invalid coordinate format: must be x,y (e.g. -12.34,56.78)");
                    System.exit(1);
                }
                this.points[i] = new Point2D.Double();
                this.points[i].setLocation(Double.parseDouble(s[0]), Double.parseDouble(s[1]));
            }
        }
        catch (Exception e) {
            VTIBathymetry.printUsage();
            return false;
        }
        if (this.mode == null) {
            System.err.println("No mode specified");
            VTIBathymetry.printUsage();
            return false;
        }
        if (this.filename == null) {
            System.err.println("No filename specified");
            return false;
        }
        return true;
    }

    public VTIBathymetry(String filename) throws IOException {
        this.filename = filename;
        this.open();
    }

    public void open() throws IOException {
        this.ncFile = NetcdfDataset.openFile((String)this.filename, null);
        this.var = this.ncFile.findVariable("z");
    }

    public void close() throws IOException {
        if (this.ncFile != null) {
            this.ncFile.close();
        }
    }

    public short getZ(Point2D.Double point) throws IOException {
        return this.getZ(point.getX(), point.getY());
    }

    public short[] getZ(Point2D.Double[] points) throws IOException {
        short[] result = new short[points.length];
        for (int i = 0; i < points.length; ++i) {
            result[i] = this.getZ(points[i].getX(), points[i].getY());
        }
        return result;
    }

    public short getZ(double x, double y) throws NullPointerException, IOException {
        int gridRow;
        int gridCol;
        int resultInt = 0;
        if (this.ncFile == null) {
            throw new NullPointerException("No netCDF file not open");
        }
        if (this.var == null) {
            throw new NullPointerException("Variable 'z' not found");
        }
        double gridColD = (x + 180.0) * 120.0;
        boolean averageWithNextCol = false;
        boolean averageWithNextRow = false;
        if (gridColD < 0.0 || gridColD >= 43200.0) {
            gridCol = 43199;
            averageWithNextCol = true;
        } else {
            gridCol = (int)Math.floor(gridColD);
            if (gridColD - (double)gridCol < 0.1) {
                gridCol = (gridCol + 43200 - 1) % 43200;
                averageWithNextCol = true;
            } else if (gridColD - (double)gridCol > 0.9) {
                averageWithNextCol = true;
            }
        }
        double gridRowD = (90.0 - y) * 120.0;
        if (gridRowD < 0.0) {
            gridRow = 0;
        } else if (gridRowD >= 21600.0) {
            gridRow = 21599;
        } else {
            gridRow = (int)Math.floor(gridRowD);
            if (gridRowD - (double)gridRow < 0.1 && gridRow > 0) {
                --gridRow;
                averageWithNextRow = true;
            } else if (gridRowD - (double)gridRow > 0.9 && gridRow < 21599) {
                averageWithNextRow = true;
            }
        }
        int[] shape = new int[]{averageWithNextCol ? 2 : 1};
        int[] origin = new int[]{43200 * gridRow + gridCol};
        short result = 0;
        try {
            Array arr = this.var.read(origin, shape);
            resultInt = arr.getShort(0);
            if (averageWithNextCol) {
                resultInt += arr.getShort(1);
            }
            if (averageWithNextRow) {
                origin[0] = origin[0] + 43200;
                arr = this.var.read(origin, shape);
                resultInt += arr.getShort(0);
                if (averageWithNextCol) {
                    resultInt += arr.getShort(1);
                }
            }
            result = (short)(resultInt / ((averageWithNextCol ? 2 : 1) * (averageWithNextRow ? 2 : 1)));
        }
        catch (InvalidRangeException e1) {
            e1.printStackTrace();
        }
        if (this.debug) {
            System.out.println("x,y --- col,row (calculated) --- col[+],row[+] (actual): " + x + "," + y + " --- " + gridColD + "," + gridRowD + " --- " + gridCol + (averageWithNextCol ? "+" : "") + "," + gridRow + (averageWithNextRow ? "+" : ""));
            System.out.print("Grid cell indexes used: " + (43200 * gridRow + gridCol));
            if (averageWithNextCol) {
                System.out.print(" " + (43200 * gridRow + (gridCol + 1) % 43200));
            }
            if (averageWithNextRow) {
                System.out.print(" " + (43200 * (gridRow + 1) + gridCol));
                if (averageWithNextCol) {
                    System.out.print(" " + (43200 * (gridRow + 1) + (gridCol + 1) % 43200));
                }
            }
            if (averageWithNextCol) {
                System.out.print(", eastern adjacent cell used");
            }
            if (averageWithNextRow) {
                System.out.print(", southern adjacent cell used");
            }
            System.out.println();
            System.out.println();
            System.out.println("Result: " + result);
        }
        return result;
    }

    private void draw() {
    }
}

