/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.HistoryViewer;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapred.MRConstants;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TIPStatus;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplitWriter;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class JobClient
extends Configured
implements MRConstants,
Tool {
    private static final Log LOG = LogFactory.getLog(JobClient.class);
    private TaskStatusFilter taskOutputFilter = TaskStatusFilter.FAILED;
    private static final long MAX_JOBPROFILE_AGE = 2000L;
    private int progMonitorPollIntervalMillis;
    private static final int DEFAULT_MONITOR_POLL_INTERVAL = 1000;
    static final String PROGRESS_MONITOR_POLL_INTERVAL_KEY = "jobclient.progress.monitor.poll.interval";
    private JobSubmissionProtocol jobSubmitClient;
    private Path sysDir = null;
    private Path stagingAreaDir = null;
    private FileSystem fs = null;
    private UserGroupInformation ugi;
    private static final String TASKLOG_PULL_TIMEOUT_KEY = "mapreduce.client.tasklog.timeout";
    private static final int DEFAULT_TASKLOG_TIMEOUT = 60000;
    static int tasklogtimeout;

    public JobClient() {
        this.progMonitorPollIntervalMillis = 1000;
    }

    public JobClient(JobConf conf) throws IOException {
        this.setConf(conf);
        this.init(conf);
    }

    public void init(JobConf conf) throws IOException {
        String tracker = conf.get("mapred.job.tracker", "local");
        tasklogtimeout = conf.getInt(TASKLOG_PULL_TIMEOUT_KEY, 60000);
        this.ugi = UserGroupInformation.getCurrentUser();
        if ("local".equals(tracker)) {
            conf.setNumMapTasks(1);
            this.jobSubmitClient = new LocalJobRunner(conf);
        } else {
            this.jobSubmitClient = this.createRPCProxy(JobTracker.getAddress(conf), conf);
        }
        this.progMonitorPollIntervalMillis = conf.getInt(PROGRESS_MONITOR_POLL_INTERVAL_KEY, 1000);
        if (this.progMonitorPollIntervalMillis < 1) {
            LOG.warn((Object)"jobclient.progress.monitor.poll.interval has been set to an invalid value;  replacing with 1000");
            this.progMonitorPollIntervalMillis = 1000;
        }
    }

    private JobSubmissionProtocol createRPCProxy(InetSocketAddress addr, Configuration conf) throws IOException {
        return (JobSubmissionProtocol)RPC.getProxy(JobSubmissionProtocol.class, 28L, addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getSocketFactory(conf, JobSubmissionProtocol.class));
    }

    public JobClient(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.ugi = UserGroupInformation.getCurrentUser();
        this.jobSubmitClient = this.createRPCProxy(jobTrackAddr, conf);
    }

    public synchronized void close() throws IOException {
        if (!(this.jobSubmitClient instanceof LocalJobRunner)) {
            RPC.stopProxy(this.jobSubmitClient);
        }
    }

    public synchronized FileSystem getFs() throws IOException {
        if (this.fs == null) {
            try {
                this.fs = this.ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws IOException {
                        Path sysDir = JobClient.this.getSystemDir();
                        return sysDir.getFileSystem(JobClient.this.getConf());
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fs;
    }

    private boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                return false;
            }
            if (!srcHost.equals(dstHost)) {
                return false;
            }
        } else {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null && dstHost == null) {
                return false;
            }
        }
        return srcUri.getPort() == dstUri.getPort();
    }

    private Path copyRemoteFiles(FileSystem jtFs, Path parentDir, Path originalPath, JobConf job, short replication) throws IOException, InterruptedException {
        FileSystem remoteFs = null;
        remoteFs = originalPath.getFileSystem(job);
        if (this.compareFs(remoteFs, jtFs)) {
            return originalPath;
        }
        Path newPath = new Path(parentDir, originalPath.getName());
        FileUtil.copy(remoteFs, originalPath, jtFs, newPath, false, job);
        jtFs.setReplication(newPath, replication);
        return newPath;
    }

    private URI getPathURI(Path destPath, String fragment) throws URISyntaxException {
        URI pathURI = destPath.toUri();
        if (pathURI.getFragment() == null) {
            pathURI = fragment == null ? new URI(pathURI.toString() + "#" + destPath.getName()) : new URI(pathURI.toString() + "#" + fragment);
        }
        return pathURI;
    }

    private void copyAndConfigureFiles(JobConf job, Path jobSubmitDir) throws IOException, InterruptedException {
        short replication = (short)job.getInt("mapred.submit.replication", 10);
        this.copyAndConfigureFiles(job, jobSubmitDir, replication);
        if (job.getWorkingDirectory() == null) {
            job.setWorkingDirectory(this.fs.getWorkingDirectory());
        }
    }

    private void copyAndConfigureFiles(JobConf job, Path submitJobDir, short replication) throws IOException, InterruptedException {
        URI pathURI;
        Path newPath;
        Path tmp;
        URI tmpURI;
        if (!job.getBoolean("mapred.used.genericoptionsparser", false)) {
            LOG.warn((Object)"Use GenericOptionsParser for parsing the arguments. Applications should implement Tool for the same.");
        }
        String files = job.get("tmpfiles");
        String libjars = job.get("tmpjars");
        String archives = job.get("tmparchives");
        FileSystem fs = submitJobDir.getFileSystem(job);
        LOG.debug((Object)("default FileSystem: " + fs.getUri()));
        if (fs.exists(submitJobDir)) {
            throw new IOException("Not submitting job. Job directory " + submitJobDir + " already exists!! This is unexpected.Please check what's there in" + " that directory");
        }
        submitJobDir = fs.makeQualified(submitJobDir);
        submitJobDir = new Path(submitJobDir.toUri().getPath());
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs(fs, submitJobDir, mapredSysPerms);
        Path filesDir = JobSubmissionFiles.getJobDistCacheFiles(submitJobDir);
        Path archivesDir = JobSubmissionFiles.getJobDistCacheArchives(submitJobDir);
        Path libjarsDir = JobSubmissionFiles.getJobDistCacheLibjars(submitJobDir);
        if (files != null) {
            String[] fileArr;
            FileSystem.mkdirs(fs, filesDir, mapredSysPerms);
            for (String tmpFile : fileArr = files.split(",")) {
                try {
                    tmpURI = new URI(tmpFile);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                tmp = new Path(tmpURI);
                newPath = this.copyRemoteFiles(fs, filesDir, tmp, job, replication);
                try {
                    pathURI = this.getPathURI(newPath, tmpURI.getFragment());
                    DistributedCache.addCacheFile(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpFile, ue);
                }
                DistributedCache.createSymlink(job);
            }
        }
        if (libjars != null) {
            String[] libjarsArr;
            FileSystem.mkdirs(fs, libjarsDir, mapredSysPerms);
            for (String tmpjars : libjarsArr = libjars.split(",")) {
                Path tmp2 = new Path(tmpjars);
                Path newPath2 = this.copyRemoteFiles(fs, libjarsDir, tmp2, job, replication);
                DistributedCache.addFileToClassPath(new Path(newPath2.toUri().getPath()), job, fs);
            }
        }
        if (archives != null) {
            String[] archivesArr;
            FileSystem.mkdirs(fs, archivesDir, mapredSysPerms);
            for (String tmpArchives : archivesArr = archives.split(",")) {
                try {
                    tmpURI = new URI(tmpArchives);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                tmp = new Path(tmpURI);
                newPath = this.copyRemoteFiles(fs, archivesDir, tmp, job, replication);
                try {
                    pathURI = this.getPathURI(newPath, tmpURI.getFragment());
                    DistributedCache.addCacheArchive(pathURI, job);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpArchives, ue);
                }
                DistributedCache.createSymlink(job);
            }
        }
        TrackerDistributedCacheManager.validate(job);
        TrackerDistributedCacheManager.determineTimestamps(job);
        TrackerDistributedCacheManager.determineCacheVisibilities(job);
        TrackerDistributedCacheManager.getDelegationTokens(job, job.getCredentials());
        String originalJarPath = job.getJar();
        if (originalJarPath != null) {
            if ("".equals(job.getJobName())) {
                job.setJobName(new Path(originalJarPath).getName());
            }
            Path submitJarFile = JobSubmissionFiles.getJobJar(submitJobDir);
            job.setJar(submitJarFile.toString());
            fs.copyFromLocalFile(new Path(originalJarPath), submitJarFile);
            fs.setReplication(submitJarFile, replication);
            fs.setPermission(submitJarFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        } else {
            LOG.warn((Object)"No job jar file set.  User classes may not be found. See JobConf(Class) or JobConf#setJar(String).");
        }
    }

    public RunningJob submitJob(String jobFile) throws FileNotFoundException, InvalidJobConfException, IOException {
        JobConf job = new JobConf(jobFile);
        return this.submitJob(job);
    }

    public RunningJob submitJob(JobConf job) throws FileNotFoundException, IOException {
        try {
            return this.submitJobInternal(job);
        }
        catch (InterruptedException ie) {
            throw new IOException("interrupted", ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("class not found", cnfe);
        }
    }

    public RunningJob submitJobInternal(final JobConf job) throws FileNotFoundException, ClassNotFoundException, InterruptedException, IOException {
        return this.ugi.doAs(new PrivilegedExceptionAction<RunningJob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RunningJob run() throws FileNotFoundException, ClassNotFoundException, InterruptedException, IOException {
                JobConf jobCopy = job;
                Path jobStagingArea = JobSubmissionFiles.getStagingDir(JobClient.this, jobCopy);
                JobID jobId = JobClient.this.jobSubmitClient.getNewJobId();
                Path submitJobDir = new Path(jobStagingArea, jobId.toString());
                jobCopy.set("mapreduce.job.dir", submitJobDir.toString());
                JobStatus status = null;
                try {
                    JobClient.this.populateTokenCache(jobCopy, jobCopy.getCredentials());
                    JobClient.this.copyAndConfigureFiles(jobCopy, submitJobDir);
                    TokenCache.obtainTokensForNamenodes(jobCopy.getCredentials(), new Path[]{submitJobDir}, jobCopy);
                    Path submitJobFile = JobSubmissionFiles.getJobConfPath(submitJobDir);
                    int reduces = jobCopy.getNumReduceTasks();
                    InetAddress ip = InetAddress.getLocalHost();
                    if (ip != null) {
                        job.setJobSubmitHostAddress(ip.getHostAddress());
                        job.setJobSubmitHostName(ip.getHostName());
                    }
                    JobContext context = new JobContext(jobCopy, jobId);
                    jobCopy = (JobConf)context.getConfiguration();
                    if (reduces == 0 ? jobCopy.getUseNewMapper() : jobCopy.getUseNewReducer()) {
                        OutputFormat<?, ?> output = ReflectionUtils.newInstance(context.getOutputFormatClass(), jobCopy);
                        output.checkOutputSpecs(context);
                    } else {
                        jobCopy.getOutputFormat().checkOutputSpecs(JobClient.this.fs, jobCopy);
                    }
                    FileSystem fs = submitJobDir.getFileSystem(jobCopy);
                    LOG.debug((Object)("Creating splits at " + fs.makeQualified(submitJobDir)));
                    int maps = JobClient.this.writeSplits(context, submitJobDir);
                    jobCopy.setNumMapTasks(maps);
                    String queue = jobCopy.getQueueName();
                    AccessControlList acl = JobClient.this.jobSubmitClient.getQueueAdmins(queue);
                    jobCopy.set(QueueManager.toFullPropertyName(queue, QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), acl.getACLString());
                    FSDataOutputStream out = FileSystem.create(fs, submitJobFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
                    try {
                        jobCopy.writeXml(out);
                    }
                    finally {
                        out.close();
                    }
                    JobClient.this.printTokens(jobId, jobCopy.getCredentials());
                    status = JobClient.this.jobSubmitClient.submitJob(jobId, submitJobDir.toString(), jobCopy.getCredentials());
                    if (status != null) {
                        NetworkedJob networkedJob = new NetworkedJob(status);
                        return networkedJob;
                    }
                    throw new IOException("Could not launch job");
                }
                finally {
                    if (status == null) {
                        LOG.info((Object)("Cleaning up the staging area " + submitJobDir));
                        if (JobClient.this.fs != null && submitJobDir != null) {
                            JobClient.this.fs.delete(submitJobDir, true);
                        }
                    }
                }
            }
        });
    }

    private void printTokens(JobID jobId, Credentials credentials) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Printing tokens for job: " + jobId));
            for (Token<? extends TokenIdentifier> token : credentials.getAllTokens()) {
                if (!token.getKind().toString().equals("HDFS_DELEGATION_TOKEN")) continue;
                LOG.debug((Object)("Submitting with " + DFSClient.stringifyToken(token)));
            }
        }
    }

    private <T extends InputSplit> int writeNewSplits(JobContext job, Path jobSubmitDir) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = job.getConfiguration();
        InputFormat<?, ?> input = ReflectionUtils.newInstance(job.getInputFormatClass(), conf);
        List<InputSplit> splits = input.getSplits(job);
        InputSplit[] array = splits.toArray(new InputSplit[splits.size()]);
        Arrays.sort(array, new SplitComparator());
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)jobSubmitDir.getFileSystem(conf), (InputSplit[])array);
        return array.length;
    }

    private int writeSplits(JobContext job, Path jobSubmitDir) throws IOException, InterruptedException, ClassNotFoundException {
        JobConf jConf = (JobConf)job.getConfiguration();
        int maps = jConf.getUseNewMapper() ? this.writeNewSplits(job, jobSubmitDir) : this.writeOldSplits(jConf, jobSubmitDir);
        return maps;
    }

    private int writeOldSplits(JobConf job, Path jobSubmitDir) throws IOException {
        org.apache.hadoop.mapred.InputSplit[] splits = job.getInputFormat().getSplits(job, job.getNumMapTasks());
        Arrays.sort(splits, new Comparator<org.apache.hadoop.mapred.InputSplit>(){

            @Override
            public int compare(org.apache.hadoop.mapred.InputSplit a, org.apache.hadoop.mapred.InputSplit b) {
                try {
                    long left = a.getLength();
                    long right = b.getLength();
                    if (left == right) {
                        return 0;
                    }
                    if (left < right) {
                        return 1;
                    }
                    return -1;
                }
                catch (IOException ie) {
                    throw new RuntimeException("Problem getting input split size", ie);
                }
            }
        });
        JobSplitWriter.createSplitFiles(jobSubmitDir, (Configuration)job, jobSubmitDir.getFileSystem(job), splits);
        return splits.length;
    }

    public static boolean isJobDirValid(Path jobDirPath, FileSystem fs) throws IOException {
        FileStatus[] contents = fs.listStatus(jobDirPath);
        int matchCount = 0;
        if (contents != null && contents.length >= 2) {
            for (FileStatus status : contents) {
                if ("job.xml".equals(status.getPath().getName())) {
                    ++matchCount;
                }
                if (!"job.split".equals(status.getPath().getName())) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return true;
            }
        }
        return false;
    }

    public RunningJob getJob(JobID jobid) throws IOException {
        JobStatus status = this.jobSubmitClient.getJobStatus(jobid);
        if (status != null) {
            return new NetworkedJob(status);
        }
        return null;
    }

    @Deprecated
    public RunningJob getJob(String jobid) throws IOException {
        return this.getJob(JobID.forName(jobid));
    }

    public TaskReport[] getMapTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getMapTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getMapTaskReports(String jobId) throws IOException {
        return this.getMapTaskReports(JobID.forName(jobId));
    }

    public TaskReport[] getReduceTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getReduceTaskReports(jobId);
    }

    public TaskReport[] getCleanupTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getCleanupTaskReports(jobId);
    }

    public TaskReport[] getSetupTaskReports(JobID jobId) throws IOException {
        return this.jobSubmitClient.getSetupTaskReports(jobId);
    }

    @Deprecated
    public TaskReport[] getReduceTaskReports(String jobId) throws IOException {
        return this.getReduceTaskReports(JobID.forName(jobId));
    }

    public void displayTasks(JobID jobId, String type, String state) throws IOException {
        TaskReport[] reports = new TaskReport[]{};
        if (type.equals("map")) {
            reports = this.getMapTaskReports(jobId);
        } else if (type.equals("reduce")) {
            reports = this.getReduceTaskReports(jobId);
        } else if (type.equals("setup")) {
            reports = this.getSetupTaskReports(jobId);
        } else if (type.equals("cleanup")) {
            reports = this.getCleanupTaskReports(jobId);
        }
        for (TaskReport report : reports) {
            TIPStatus status = report.getCurrentStatus();
            if (!(state.equals("pending") && status == TIPStatus.PENDING || state.equals("running") && status == TIPStatus.RUNNING || state.equals("completed") && status == TIPStatus.COMPLETE || state.equals("failed") && status == TIPStatus.FAILED) && (!state.equals("killed") || status != TIPStatus.KILLED)) continue;
            this.printTaskAttempts(report);
        }
    }

    private void printTaskAttempts(TaskReport report) {
        if (report.getCurrentStatus() == TIPStatus.COMPLETE) {
            System.out.println(report.getSuccessfulTaskAttempt());
        } else if (report.getCurrentStatus() == TIPStatus.RUNNING) {
            for (TaskAttemptID t : report.getRunningTaskAttempts()) {
                System.out.println(t);
            }
        }
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return this.getClusterStatus(false);
    }

    public ClusterStatus getClusterStatus(boolean detailed) throws IOException {
        return this.jobSubmitClient.getClusterStatus(detailed);
    }

    public Path getStagingAreaDir() throws IOException {
        if (this.stagingAreaDir == null) {
            this.stagingAreaDir = new Path(this.jobSubmitClient.getStagingAreaDir());
        }
        return this.stagingAreaDir;
    }

    public JobStatus[] jobsToComplete() throws IOException {
        return this.jobSubmitClient.jobsToComplete();
    }

    private static void downloadProfile(TaskCompletionEvent e) throws IOException {
        URLConnection connection = new URL(JobClient.getTaskLogURL(e.getTaskAttemptId(), e.getTaskTrackerHttp()) + "&filter=profile").openConnection();
        InputStream in = connection.getInputStream();
        FileOutputStream out = new FileOutputStream(e.getTaskAttemptId() + ".profile");
        IOUtils.copyBytes(in, (OutputStream)out, 65536, true);
    }

    public JobStatus[] getAllJobs() throws IOException {
        return this.jobSubmitClient.getAllJobs();
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        JobClient jc = new JobClient(job);
        RunningJob rj = jc.submitJob(job);
        try {
            if (!jc.monitorAndPrintJob(job, rj)) {
                LOG.info((Object)("Job Failed: " + rj.getFailureInfo()));
                throw new IOException("Job failed!");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return rj;
    }

    private boolean shouldDownloadProfile(JobConf conf) {
        String profileParams = conf.getProfileParams();
        if (null == profileParams) {
            return false;
        }
        String[] parts = profileParams.split("[ \\t]+");
        boolean hprofFound = false;
        boolean fileFound = false;
        for (String p : parts) {
            String[] subparts;
            if (!p.startsWith("-agentlib:hprof") && !p.startsWith("-Xrunhprof")) continue;
            hprofFound = true;
            for (String sub : subparts = p.split(",")) {
                if (!sub.startsWith("file=") || sub.length() == "file=".length()) continue;
                fileFound = true;
            }
        }
        return hprofFound && fileFound;
    }

    public boolean monitorAndPrintJob(JobConf conf, RunningJob job) throws IOException, InterruptedException {
        String lastReport = null;
        TaskStatusFilter filter = JobClient.getTaskOutputFilter(conf);
        JobID jobId = job.getID();
        LOG.info((Object)("Running job: " + jobId));
        int eventCounter = 0;
        boolean profiling = conf.getProfileEnabled();
        Configuration.IntegerRanges mapRanges = conf.getProfileTaskRange(true);
        Configuration.IntegerRanges reduceRanges = conf.getProfileTaskRange(false);
        while (!job.isComplete()) {
            Thread.sleep(this.progMonitorPollIntervalMillis);
            String report = " map " + StringUtils.formatPercent(job.mapProgress(), 0) + " reduce " + StringUtils.formatPercent(job.reduceProgress(), 0);
            if (!report.equals(lastReport)) {
                LOG.info((Object)report);
                lastReport = report;
            }
            TaskCompletionEvent[] events = job.getTaskCompletionEvents(eventCounter);
            eventCounter += events.length;
            block10: for (TaskCompletionEvent event : events) {
                TaskCompletionEvent.Status status = event.getTaskStatus();
                if (profiling && this.shouldDownloadProfile(conf) && (status == TaskCompletionEvent.Status.SUCCEEDED || status == TaskCompletionEvent.Status.FAILED) && (event.isMap ? mapRanges : reduceRanges).isIncluded(event.idWithinJob())) {
                    JobClient.downloadProfile(event);
                }
                switch (filter) {
                    case NONE: {
                        continue block10;
                    }
                    case SUCCEEDED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) continue block10;
                        LOG.info((Object)event.toString());
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                        continue block10;
                    }
                    case FAILED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.FAILED) continue block10;
                        LOG.info((Object)event.toString());
                        TaskAttemptID taskId = event.getTaskAttemptId();
                        String[] taskDiagnostics = this.jobSubmitClient.getTaskDiagnostics(taskId);
                        if (taskDiagnostics != null) {
                            for (String diagnostics : taskDiagnostics) {
                                System.err.println(diagnostics);
                            }
                        }
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                        continue block10;
                    }
                    case KILLED: {
                        if (event.getTaskStatus() != TaskCompletionEvent.Status.KILLED) continue block10;
                        LOG.info((Object)event.toString());
                        continue block10;
                    }
                    case ALL: {
                        LOG.info((Object)event.toString());
                        JobClient.displayTaskLogs(event.getTaskAttemptId(), event.getTaskTrackerHttp());
                    }
                }
            }
        }
        LOG.info((Object)("Job complete: " + jobId));
        Counters counters = null;
        try {
            counters = job.getCounters();
        }
        catch (IOException ie) {
            counters = null;
            LOG.info((Object)ie.getMessage());
        }
        if (counters != null) {
            counters.log(LOG);
        }
        return job.isSuccessful();
    }

    static String getTaskLogURL(TaskAttemptID taskId, String baseUrl) {
        return baseUrl + "/tasklog?plaintext=true&attemptid=" + taskId;
    }

    private static void displayTaskLogs(TaskAttemptID taskId, String baseUrl) throws IOException {
        if (baseUrl != null) {
            String taskLogUrl = JobClient.getTaskLogURL(taskId, baseUrl);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stdout"), System.out);
            JobClient.getTaskLogs(taskId, new URL(taskLogUrl + "&filter=stderr"), System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getTaskLogs(TaskAttemptID taskId, URL taskLogUrl, OutputStream out) {
        try {
            URLConnection connection = taskLogUrl.openConnection();
            connection.setReadTimeout(tasklogtimeout);
            connection.setConnectTimeout(tasklogtimeout);
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
            try {
                String logData = null;
                while ((logData = input.readLine()) != null) {
                    if (logData.length() <= 0) continue;
                    output.write(taskId + ": " + logData + "\n");
                    output.flush();
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Error reading task output" + ioe.getMessage()));
        }
    }

    static Configuration getConfiguration(String jobTrackerSpec) {
        Configuration conf = new Configuration();
        if (jobTrackerSpec != null) {
            if (jobTrackerSpec.indexOf(":") >= 0) {
                conf.set("mapred.job.tracker", jobTrackerSpec);
            } else {
                String classpathFile = "hadoop-" + jobTrackerSpec + ".xml";
                URL validate = conf.getResource(classpathFile);
                if (validate == null) {
                    throw new RuntimeException(classpathFile + " not found on CLASSPATH");
                }
                conf.addResource(classpathFile);
            }
        }
        return conf;
    }

    @Deprecated
    public void setTaskOutputFilter(TaskStatusFilter newValue) {
        this.taskOutputFilter = newValue;
    }

    public static TaskStatusFilter getTaskOutputFilter(JobConf job) {
        return TaskStatusFilter.valueOf(job.get("jobclient.output.filter", "FAILED"));
    }

    public static void setTaskOutputFilter(JobConf job, TaskStatusFilter newValue) {
        job.set("jobclient.output.filter", newValue.toString());
    }

    @Deprecated
    public TaskStatusFilter getTaskOutputFilter() {
        return this.taskOutputFilter;
    }

    private String getJobPriorityNames() {
        StringBuffer sb = new StringBuffer();
        for (JobPriority p : JobPriority.values()) {
            sb.append(p.name()).append(" ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void displayUsage(String cmd) {
        String prefix = "Usage: JobClient ";
        String jobPriorityValues = this.getJobPriorityNames();
        String taskTypes = "map, reduce, setup, cleanup";
        String taskStates = "running, completed";
        if ("-submit".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-file>]");
        } else if ("-status".equals(cmd) || "-kill".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id>]");
        } else if ("-counter".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <group-name> <counter-name>]");
        } else if ("-events".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <from-event-#> <#-of-events>]");
        } else if ("-history".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <jobOutputDir>]");
        } else if ("-list".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " [all]]");
        } else if ("-kill-task".equals(cmd) || "-fail-task".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <task-id>]");
        } else if ("-set-priority".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <priority>]. " + "Valid values for priorities are: " + jobPriorityValues);
        } else if ("-list-active-trackers".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "]");
        } else if ("-list-blacklisted-trackers".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + "]");
        } else if ("-list-attempt-ids".equals(cmd)) {
            System.err.println(prefix + "[" + cmd + " <job-id> <task-type> <task-state>]. " + "Valid values for <task-type> are " + taskTypes + ". " + "Valid values for <task-state> are " + taskStates);
        } else {
            System.err.printf(prefix + "<command> <args>\n", new Object[0]);
            System.err.printf("\t[-submit <job-file>]\n", new Object[0]);
            System.err.printf("\t[-status <job-id>]\n", new Object[0]);
            System.err.printf("\t[-counter <job-id> <group-name> <counter-name>]\n", new Object[0]);
            System.err.printf("\t[-kill <job-id>]\n", new Object[0]);
            System.err.printf("\t[-set-priority <job-id> <priority>]. Valid values for priorities are: " + jobPriorityValues + "\n", new Object[0]);
            System.err.printf("\t[-events <job-id> <from-event-#> <#-of-events>]\n", new Object[0]);
            System.err.printf("\t[-history <jobOutputDir>]\n", new Object[0]);
            System.err.printf("\t[-list [all]]\n", new Object[0]);
            System.err.printf("\t[-list-active-trackers]\n", new Object[0]);
            System.err.printf("\t[-list-blacklisted-trackers]\n", new Object[0]);
            System.err.println("\t[-list-attempt-ids <job-id> <task-type> <task-state>]\n");
            System.err.printf("\t[-kill-task <task-id>]\n", new Object[0]);
            System.err.printf("\t[-fail-task <task-id>]\n\n", new Object[0]);
            ToolRunner.printGenericCommandUsage(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String[] argv) throws Exception {
        int exitCode;
        block95: {
            exitCode = -1;
            if (argv.length < 1) {
                this.displayUsage("");
                return exitCode;
            }
            String cmd = argv[0];
            String submitJobFile = null;
            String jobid = null;
            String taskid = null;
            String outputDir = null;
            String counterGroupName = null;
            String counterName = null;
            String newPriority = null;
            String taskType = null;
            String taskState = null;
            int fromEvent = 0;
            int nEvents = 0;
            boolean getStatus = false;
            boolean getCounter = false;
            boolean killJob = false;
            boolean listEvents = false;
            boolean viewHistory = false;
            boolean viewAllHistory = false;
            boolean listJobs = false;
            boolean listAllJobs = false;
            boolean listActiveTrackers = false;
            boolean listBlacklistedTrackers = false;
            boolean displayTasks = false;
            boolean killTask = false;
            boolean failTask = false;
            boolean setJobPriority = false;
            if ("-submit".equals(cmd)) {
                if (argv.length != 2) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                submitJobFile = argv[1];
            } else if ("-status".equals(cmd)) {
                if (argv.length != 2) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                jobid = argv[1];
                getStatus = true;
            } else if ("-counter".equals(cmd)) {
                if (argv.length != 4) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                getCounter = true;
                jobid = argv[1];
                counterGroupName = argv[2];
                counterName = argv[3];
            } else if ("-kill".equals(cmd)) {
                if (argv.length != 2) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                jobid = argv[1];
                killJob = true;
            } else if ("-set-priority".equals(cmd)) {
                if (argv.length != 3) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                jobid = argv[1];
                newPriority = argv[2];
                try {
                    JobPriority jp = JobPriority.valueOf(newPriority);
                }
                catch (IllegalArgumentException iae) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                setJobPriority = true;
            } else if ("-events".equals(cmd)) {
                if (argv.length != 4) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                jobid = argv[1];
                fromEvent = Integer.parseInt(argv[2]);
                nEvents = Integer.parseInt(argv[3]);
                listEvents = true;
            } else if ("-history".equals(cmd)) {
                if (!(argv.length == 2 || argv.length == 3 && "all".equals(argv[1]))) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                viewHistory = true;
                if (argv.length == 3 && "all".equals(argv[1])) {
                    viewAllHistory = true;
                    outputDir = argv[2];
                } else {
                    outputDir = argv[1];
                }
            } else if ("-list".equals(cmd)) {
                if (!(argv.length == 1 || argv.length == 2 && "all".equals(argv[1]))) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                if (argv.length == 2 && "all".equals(argv[1])) {
                    listAllJobs = true;
                } else {
                    listJobs = true;
                }
            } else if ("-kill-task".equals(cmd)) {
                if (argv.length != 2) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                killTask = true;
                taskid = argv[1];
            } else if ("-fail-task".equals(cmd)) {
                if (argv.length != 2) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                failTask = true;
                taskid = argv[1];
            } else if ("-list-active-trackers".equals(cmd)) {
                if (argv.length != 1) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                listActiveTrackers = true;
            } else if ("-list-blacklisted-trackers".equals(cmd)) {
                if (argv.length != 1) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                listBlacklistedTrackers = true;
            } else if ("-list-attempt-ids".equals(cmd)) {
                if (argv.length != 4) {
                    this.displayUsage(cmd);
                    return exitCode;
                }
                jobid = argv[1];
                taskType = argv[2];
                taskState = argv[3];
                displayTasks = true;
            } else {
                this.displayUsage(cmd);
                return exitCode;
            }
            JobConf conf = null;
            conf = submitJobFile != null ? new JobConf(submitJobFile) : new JobConf(this.getConf());
            this.init(conf);
            try {
                if (submitJobFile != null) {
                    RunningJob job = this.submitJob(conf);
                    System.out.println("Created job " + job.getID());
                    exitCode = 0;
                } else if (getStatus) {
                    RunningJob job = this.getJob(JobID.forName(jobid));
                    if (job == null) {
                        System.out.println("Could not find job " + jobid);
                    } else {
                        Counters counters = job.getCounters();
                        System.out.println();
                        System.out.println(job);
                        if (counters != null) {
                            System.out.println(counters);
                        } else {
                            System.out.println("Counters not available. Job is retired.");
                        }
                        exitCode = 0;
                    }
                } else if (getCounter) {
                    RunningJob job = this.getJob(JobID.forName(jobid));
                    if (job == null) {
                        System.out.println("Could not find job " + jobid);
                    } else {
                        Counters counters = job.getCounters();
                        if (counters == null) {
                            System.out.println("Counters not available for retired job " + jobid);
                            exitCode = -1;
                        } else {
                            Counters.Group group = counters.getGroup(counterGroupName);
                            Counters.Counter counter = group.getCounterForName(counterName);
                            System.out.println(counter.getCounter());
                            exitCode = 0;
                        }
                    }
                } else if (killJob) {
                    RunningJob job = this.getJob(JobID.forName(jobid));
                    if (job == null) {
                        System.out.println("Could not find job " + jobid);
                    } else {
                        job.killJob();
                        System.out.println("Killed job " + jobid);
                        exitCode = 0;
                    }
                } else if (setJobPriority) {
                    RunningJob job = this.getJob(JobID.forName(jobid));
                    if (job == null) {
                        System.out.println("Could not find job " + jobid);
                    } else {
                        job.setJobPriority(newPriority);
                        System.out.println("Changed job priority.");
                        exitCode = 0;
                    }
                } else if (viewHistory) {
                    this.viewHistory(outputDir, viewAllHistory);
                    exitCode = 0;
                } else if (listEvents) {
                    this.listEvents(JobID.forName(jobid), fromEvent, nEvents);
                    exitCode = 0;
                } else if (listJobs) {
                    this.listJobs();
                    exitCode = 0;
                } else if (listAllJobs) {
                    this.listAllJobs();
                    exitCode = 0;
                } else if (listActiveTrackers) {
                    this.listActiveTrackers();
                    exitCode = 0;
                } else if (listBlacklistedTrackers) {
                    this.listBlacklistedTrackers();
                    exitCode = 0;
                } else if (displayTasks) {
                    this.displayTasks(JobID.forName(jobid), taskType, taskState);
                } else if (killTask) {
                    if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), false)) {
                        System.out.println("Killed task " + taskid);
                        exitCode = 0;
                    } else {
                        System.out.println("Could not kill task " + taskid);
                        exitCode = -1;
                    }
                } else if (failTask) {
                    if (this.jobSubmitClient.killTask(TaskAttemptID.forName(taskid), true)) {
                        System.out.println("Killed task " + taskid + " by failing it");
                        exitCode = 0;
                    } else {
                        System.out.println("Could not fail task " + taskid);
                        exitCode = -1;
                    }
                }
            }
            catch (RemoteException re) {
                IOException unwrappedException = re.unwrapRemoteException();
                if (unwrappedException instanceof AccessControlException) {
                    System.out.println(unwrappedException.getMessage());
                    break block95;
                }
                throw re;
            }
            finally {
                this.close();
            }
        }
        return exitCode;
    }

    private void viewHistory(String outputDir, boolean all) throws IOException {
        HistoryViewer historyViewer = new HistoryViewer(outputDir, this.getConf(), all);
        historyViewer.print();
    }

    private void listEvents(JobID jobId, int fromEventId, int numEvents) throws IOException {
        TaskCompletionEvent[] events = this.jobSubmitClient.getTaskCompletionEvents(jobId, fromEventId, numEvents);
        System.out.println("Task completion events for " + jobId);
        System.out.println("Number of events (from " + fromEventId + ") are: " + events.length);
        for (TaskCompletionEvent event : events) {
            System.out.println((Object)((Object)event.getTaskStatus()) + " " + event.getTaskAttemptId() + " " + JobClient.getTaskLogURL(event.getTaskAttemptId(), event.getTaskTrackerHttp()));
        }
    }

    private void listJobs() throws IOException {
        JobStatus[] jobs = this.jobsToComplete();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs currently running\n", jobs.length);
        this.displayJobList(jobs);
    }

    private void listAllJobs() throws IOException {
        JobStatus[] jobs = this.getAllJobs();
        if (jobs == null) {
            jobs = new JobStatus[]{};
        }
        System.out.printf("%d jobs submitted\n", jobs.length);
        System.out.printf("States are:\n\tRunning : 1\tSucceded : 2\tFailed : 3\tPrep : 4\n", new Object[0]);
        this.displayJobList(jobs);
    }

    private void listActiveTrackers() throws IOException {
        ClusterStatus c = this.jobSubmitClient.getClusterStatus(true);
        Collection<String> trackers = c.getActiveTrackerNames();
        for (String trackerName : trackers) {
            System.out.println(trackerName);
        }
    }

    private void listBlacklistedTrackers() throws IOException {
        ClusterStatus c = this.jobSubmitClient.getClusterStatus(true);
        Collection<String> trackers = c.getBlacklistedTrackerNames();
        for (String trackerName : trackers) {
            System.out.println(trackerName);
        }
    }

    void displayJobList(JobStatus[] jobs) {
        System.out.printf("JobId\tState\tStartTime\tUserName\tPriority\tSchedulingInfo\n", new Object[0]);
        for (JobStatus job : jobs) {
            System.out.printf("%s\t%d\t%d\t%s\t%s\t%s\n", job.getJobID(), job.getRunState(), job.getStartTime(), job.getUsername(), job.getJobPriority().name(), job.getSchedulingInfo());
        }
    }

    public int getDefaultMaps() throws IOException {
        return this.getClusterStatus().getMaxMapTasks();
    }

    public int getDefaultReduces() throws IOException {
        return this.getClusterStatus().getMaxReduceTasks();
    }

    public Path getSystemDir() {
        if (this.sysDir == null) {
            this.sysDir = new Path(this.jobSubmitClient.getSystemDir());
        }
        return this.sysDir;
    }

    public JobQueueInfo[] getQueues() throws IOException {
        return this.jobSubmitClient.getQueues();
    }

    public JobStatus[] getJobsFromQueue(String queueName) throws IOException {
        return this.jobSubmitClient.getJobsFromQueue(queueName);
    }

    public JobQueueInfo getQueueInfo(String queueName) throws IOException {
        return this.jobSubmitClient.getQueueInfo(queueName);
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return this.jobSubmitClient.getQueueAclsForCurrentUser();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        Token<DelegationTokenIdentifier> result = this.jobSubmitClient.getDelegationToken(renewer);
        InetSocketAddress addr = JobTracker.getAddress(this.getConf());
        StringBuilder service = new StringBuilder();
        service.append(NetUtils.normalizeHostName(addr.getAddress().getHostAddress()));
        service.append(':');
        service.append(addr.getPort());
        result.setService(new Text(service.toString()));
        return result;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        try {
            return this.jobSubmitClient.renewDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        try {
            this.jobSubmitClient.cancelDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new JobClient(), argv);
        System.exit(res);
    }

    private void readTokensFromFiles(Configuration conf, Credentials credentials) throws IOException {
        String tokensFileName;
        String binaryTokenFilename = conf.get("mapreduce.job.credentials.binary");
        if (binaryTokenFilename != null) {
            Credentials binary = Credentials.readTokenStorageFile(new Path("file:///" + binaryTokenFilename), conf);
            credentials.addAll(binary);
        }
        if ((tokensFileName = conf.get("mapreduce.job.credentials.json")) != null) {
            LOG.info((Object)("loading user's secret keys from " + tokensFileName));
            String localFileName = new Path(tokensFileName).toUri().getPath();
            boolean json_error = false;
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map nm = (Map)mapper.readValue(new File(localFileName), Map.class);
                for (Map.Entry ent : nm.entrySet()) {
                    credentials.addSecretKey(new Text((String)ent.getKey()), ((String)ent.getValue()).getBytes());
                }
            }
            catch (JsonMappingException e) {
                json_error = true;
            }
            catch (JsonParseException e) {
                json_error = true;
            }
            if (json_error) {
                LOG.warn((Object)"couldn't parse Token Cache JSON file with user secret keys");
            }
        }
    }

    private void populateTokenCache(Configuration conf, Credentials credentials) throws IOException {
        this.readTokensFromFiles(conf, credentials);
        Object[] nameNodes = conf.getStrings("mapreduce.job.hdfs-servers");
        LOG.debug((Object)("adding the following namenodes' delegation tokens:" + Arrays.toString(nameNodes)));
        if (nameNodes != null) {
            Path[] ps = new Path[nameNodes.length];
            for (int i = 0; i < nameNodes.length; ++i) {
                ps[i] = new Path((String)nameNodes[i]);
            }
            TokenCache.obtainTokensForNamenodes(credentials, ps, conf);
        }
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
    }

    private static class SplitComparator
    implements Comparator<InputSplit> {
        private SplitComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
        }
    }

    class NetworkedJob
    implements RunningJob {
        JobProfile profile;
        JobStatus status;
        long statustime;
        private int completionPollIntervalMillis;
        private static final int DEFAULT_COMPLETION_POLL_INTERVAL = 5000;
        static final String COMPLETION_POLL_INTERVAL_KEY = "jobclient.completion.poll.interval";

        public NetworkedJob(JobStatus job) throws IOException {
            this.status = job;
            this.profile = JobClient.this.jobSubmitClient.getJobProfile(job.getJobID());
            this.statustime = System.currentTimeMillis();
            Configuration conf = JobClient.this.getConf();
            this.completionPollIntervalMillis = conf.getInt(COMPLETION_POLL_INTERVAL_KEY, 5000);
            if (this.completionPollIntervalMillis < 1) {
                LOG.warn((Object)"jobclient.completion.poll.interval has been set to an invalid value; replacing with 5000");
                this.completionPollIntervalMillis = 5000;
            }
        }

        synchronized void ensureFreshStatus() throws IOException {
            if (System.currentTimeMillis() - this.statustime > 2000L) {
                this.updateStatus();
            }
        }

        synchronized void updateStatus() throws IOException {
            this.status = JobClient.this.jobSubmitClient.getJobStatus(this.profile.getJobID());
            this.statustime = System.currentTimeMillis();
        }

        @Override
        public JobID getID() {
            return this.profile.getJobID();
        }

        @Override
        @Deprecated
        public String getJobID() {
            return this.profile.getJobID().toString();
        }

        @Override
        public String getJobName() {
            return this.profile.getJobName();
        }

        @Override
        public String getJobFile() {
            return this.profile.getJobFile();
        }

        @Override
        public String getTrackingURL() {
            return this.profile.getURL().toString();
        }

        @Override
        public float mapProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.mapProgress();
        }

        @Override
        public float reduceProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.reduceProgress();
        }

        @Override
        public float cleanupProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.cleanupProgress();
        }

        @Override
        public float setupProgress() throws IOException {
            this.ensureFreshStatus();
            return this.status.setupProgress();
        }

        @Override
        public synchronized boolean isComplete() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2 || this.status.getRunState() == 3 || this.status.getRunState() == 5;
        }

        @Override
        public synchronized boolean isSuccessful() throws IOException {
            this.updateStatus();
            return this.status.getRunState() == 2;
        }

        @Override
        public void waitForCompletion() throws IOException {
            while (!this.isComplete()) {
                try {
                    Thread.sleep(this.completionPollIntervalMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public synchronized int getJobState() throws IOException {
            this.updateStatus();
            return this.status.getRunState();
        }

        @Override
        public synchronized void killJob() throws IOException {
            JobClient.this.jobSubmitClient.killJob(this.getID());
        }

        @Override
        public synchronized void setJobPriority(String priority) throws IOException {
            JobClient.this.jobSubmitClient.setJobPriority(this.getID(), priority);
        }

        @Override
        public synchronized void killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
            JobClient.this.jobSubmitClient.killTask(taskId, shouldFail);
        }

        @Override
        @Deprecated
        public synchronized void killTask(String taskId, boolean shouldFail) throws IOException {
            this.killTask(TaskAttemptID.forName(taskId), shouldFail);
        }

        @Override
        public synchronized TaskCompletionEvent[] getTaskCompletionEvents(int startFrom) throws IOException {
            return JobClient.this.jobSubmitClient.getTaskCompletionEvents(this.getID(), startFrom, 10);
        }

        public String toString() {
            try {
                this.updateStatus();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return "Job: " + this.profile.getJobID() + "\n" + "file: " + this.profile.getJobFile() + "\n" + "tracking URL: " + this.profile.getURL() + "\n" + "map() completion: " + this.status.mapProgress() + "\n" + "reduce() completion: " + this.status.reduceProgress();
        }

        @Override
        public Counters getCounters() throws IOException {
            return JobClient.this.jobSubmitClient.getJobCounters(this.getID());
        }

        @Override
        public String[] getTaskDiagnostics(TaskAttemptID id) throws IOException {
            return JobClient.this.jobSubmitClient.getTaskDiagnostics(id);
        }

        @Override
        public String getFailureInfo() throws IOException {
            this.ensureFreshStatus();
            return this.status.getFailureInfo();
        }
    }

    public static enum TaskStatusFilter {
        NONE,
        KILLED,
        FAILED,
        SUCCEEDED,
        ALL;

    }
}

