/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.db.DBSplitter;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;

public class IntegerSplitter
implements DBSplitter {
    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        long minVal = results.getLong(1);
        long maxVal = results.getLong(2);
        String lowClausePrefix = colName + " >= ";
        String highClausePrefix = colName + " < ";
        int numSplits = conf.getInt("mapred.map.tasks", 1);
        if (numSplits < 1) {
            numSplits = 1;
        }
        if (results.getString(1) == null && results.getString(2) == null) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        List<Long> splitPoints = this.split(numSplits, minVal, maxVal);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        long start = splitPoints.get(0);
        for (int i = 1; i < splitPoints.size(); ++i) {
            long end = splitPoints.get(i);
            if (i == splitPoints.size() - 1) {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Long.toString(start), colName + " <= " + Long.toString(end)));
            } else {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Long.toString(start), highClausePrefix + Long.toString(end)));
            }
            start = end;
        }
        if (results.getString(1) == null || results.getString(2) == null) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
        }
        return splits;
    }

    List<Long> split(long numSplits, long minVal, long maxVal) throws SQLException {
        ArrayList<Long> splits = new ArrayList<Long>();
        long splitSize = (maxVal - minVal) / numSplits;
        if (splitSize < 1L) {
            splitSize = 1L;
        }
        for (long curVal = minVal; curVal <= maxVal; curVal += splitSize) {
            splits.add(curVal);
        }
        if ((Long)splits.get(splits.size() - 1) != maxVal || splits.size() == 1) {
            splits.add(maxVal);
        }
        return splits;
    }
}

