/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.ird.kernel_density;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.common.input.ListInputResource;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.StreamingPackagedAlgorithm;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAlgorithm;

public class KernelDensity
extends AbstractAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<String> errors = new ArrayList<String>();

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        List<String> names = InputUtils.getListStringInputParameter(inputData, "species", true);
        List<Integer> percentages = InputUtils.getListIntegerInputParameter(inputData, "percentages");
        String percs = this.getPercentagesListParameter(percentages);
        String fromDate = InputUtils.getStringInputParameter(inputData, "fromDate");
        String toDate = InputUtils.getStringInputParameter(inputData, "toDate");
        Boolean mask = InputUtils.getBooleanInputParameter(inputData, "mask", new Boolean(false));
        this.logger.info((Object)"Running Job KERNEL DENSITY...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        StreamingPackagedAlgorithm streaming = new StreamingPackagedAlgorithm(conf);
        streaming.setAlgorithmName("kernelDensity");
        streaming.setInputResource(new ListInputResource(names));
        if (fromDate != null) {
            streaming.addFixedParameter("fromDate", fromDate);
        }
        if (toDate != null) {
            streaming.addFixedParameter("toDate", toDate);
        }
        streaming.addFixedParameter("percentages", percs != null ? percs : "25;50;75;80;90;95;98");
        streaming.addFixedParameter("mask", mask);
        streaming.setDebugMode(true);
        try {
            ResultsInfo result = streaming.runSync();
            HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
            wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
            return wpsResultMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Execution job failed! " + e.getMessage());
        }
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class<?> getInputDataType(String id) {
        if (id.contentEquals("percentages")) {
            return LiteralIntBinding.class;
        }
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    private String getPercentagesListParameter(List<Integer> percentages) {
        if (percentages == null || percentages.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Integer percentage : percentages) {
            sb.append((i++ == 0 ? "" : ";") + percentage);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }
}

