/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client;

import com.terradue.jcatalogue.client.AtomEntity;
import com.terradue.jcatalogue.client.CatalogueClient;
import com.terradue.jcatalogue.client.DataSet;
import com.terradue.jcatalogue.client.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Series
extends AtomEntity
implements Iterable<DataSet> {
    private final List<DataSet> dataSets = new ArrayList<DataSet>();

    public void addDataSet(DataSet dataSet) {
        this.dataSets.add(dataSet);
    }

    @Override
    public Iterator<DataSet> iterator() {
        return this.dataSets.iterator();
    }

    public Series getNextResults() {
        if (!this.hasMoreResults()) {
            throw new IllegalStateException("More results not available");
        }
        return this.getCatalogueClient().getSeries(this.getNextResultsUri(), new Parameter[0]);
    }

    @Override
    void setCatalogueClient(CatalogueClient catalogueClient) {
        super.setCatalogueClient(catalogueClient);
        for (DataSet dataSet : this.dataSets) {
            dataSet.setCatalogueClient(catalogueClient);
        }
    }

    @Override
    public String toString() {
        return "Series(dataSets=" + this.dataSets + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Series)) {
            return false;
        }
        Series other = (Series)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return !(this.dataSets == null ? other.dataSets != null : !((Object)this.dataSets).equals(other.dataSets));
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof Series;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + super.hashCode();
        result = result * 31 + (this.dataSets == null ? 0 : ((Object)this.dataSets).hashCode());
        return result;
    }
}

