/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.collections;

import java.net.URI;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public final class Enclosures
implements Comparator<Integer>,
Iterable<URI> {
    private final Map<Integer, Set<URI>> enclosures = new TreeMap<Integer, Set<URI>>(this);

    public void addEnclosure(URI uri, Integer priority) {
        Set<URI> enclosuresSet = this.enclosures.get(priority);
        if (enclosuresSet == null) {
            enclosuresSet = new HashSet<URI>();
            this.enclosures.put(priority, enclosuresSet);
        }
        enclosuresSet.add(uri);
    }

    @Override
    public Iterator<URI> iterator() {
        return new Iterator<URI>(){
            private Iterator<Integer> keys;
            private Iterator<URI> pending;
            private URI next;
            {
                this.keys = Enclosures.this.enclosures.keySet().iterator();
                this.pending = null;
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (this.pending == null || !this.pending.hasNext()) {
                    if (!this.keys.hasNext()) {
                        return false;
                    }
                    this.pending = ((Set)Enclosures.this.enclosures.get(this.keys.next())).iterator();
                }
                this.next = this.pending.next();
                return true;
            }

            @Override
            public URI next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URI returned = this.next;
                this.next = null;
                return returned;
            }

            @Override
            public void remove() {
                this.pending.remove();
            }
        };
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return o1.compareTo(o2);
    }
}

