/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.internal.digester;

import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.binder.RuleProvider;
import org.xml.sax.Attributes;

final class PriorityParamRule
extends Rule {
    private static final Integer MIN_PRIORITY = 999999;
    private final int paramIndex;

    private PriorityParamRule(int paramIndex) {
        this.paramIndex = paramIndex;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Integer priority = MIN_PRIORITY;
        String priorityValue = attributes.getValue("urn:ietf:params:xml:ns:metalink", "priority");
        if (priorityValue != null) {
            priority = Integer.valueOf(priorityValue);
        }
        this.getDigester().peekParams()[this.paramIndex] = priority;
    }

    public static final class PriorityParamRuleProvider
    implements RuleProvider<PriorityParamRule> {
        private final int paramIndex;

        public PriorityParamRuleProvider(int paramIndex) {
            this.paramIndex = paramIndex;
        }

        public PriorityParamRule get() {
            return new PriorityParamRule(this.paramIndex);
        }
    }
}

