/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common.input;

import com.terradue.wps_hadoop.common.input.InputResource;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

public class ListInputResource
implements InputResource {
    List<String> list = new ArrayList<String>();

    public ListInputResource(List<String> list) {
        this.list = list;
    }

    public ListInputResource(String ... list) {
        this.list = Arrays.asList(list);
    }

    public ListInputResource(List<IData> idatas, Class<IData> c) {
        for (IData idata : idatas) {
            this.list.add(((LiteralStringBinding)idata).getPayload());
        }
    }

    @Override
    public File createLocalFile(String pathName) throws IOException {
        File file = new File(pathName);
        BufferedWriter buff = new BufferedWriter(new FileWriter(file));
        for (String str : this.list) {
            buff.write(str + "\n");
        }
        buff.close();
        return file;
    }

    @Override
    public void writeToStream(DataOutputStream stream) throws IOException {
        for (String str : this.list) {
            stream.writeBytes(str + "\n");
        }
    }
}

