/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordTransBuilderIF;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.unidata.geoloc.vertical.VerticalTransform;

@Immutable
public class VerticalCT
extends CoordinateTransform {
    private final Type type;
    private final CoordTransBuilderIF builder;
    private static Map<String, Type> hash = new HashMap<String, Type>(10);

    public VerticalCT(String name, String authority, Type type, CoordTransBuilderIF builder) {
        super(name, authority, TransformType.Vertical);
        this.type = type;
        this.builder = builder;
    }

    public VerticalCT(VerticalCT from) {
        super(from.getName(), from.getAuthority(), from.getTransformType());
        this.type = from.getVerticalTransformType();
        this.builder = from.getBuilder();
    }

    public Type getVerticalTransformType() {
        return this.type;
    }

    public VerticalTransform makeVerticalTransform(NetcdfDataset ds, Dimension timeDim) {
        return this.builder.makeMathTransform(ds, timeDim, this);
    }

    public CoordTransBuilderIF getBuilder() {
        return this.builder;
    }

    @Override
    public String toString() {
        return "VerticalCT {type=" + this.type + ", builder=" + this.builder.getTransformName() + '}';
    }

    public static class Type {
        public static final Type Sigma = new Type("atmosphere_sigma");
        public static final Type HybridSigmaPressure = new Type("atmosphere_hybrid_sigma_pressure");
        public static final Type HybridHeight = new Type("atmosphere_hybrid_height");
        public static final Type Sleve = new Type("atmosphere_sleve");
        public static final Type OceanSigma = new Type("ocean_sigma");
        public static final Type OceanS = new Type("ocean_s");
        public static final Type OceanSigmaZ = new Type("ocean_sigma_z");
        public static final Type Existing3DField = new Type("Existing3DField");
        public static final Type WRFEta = new Type("WRFEta");
        public static final Type OceanSG1 = new Type("ocean_s_g1");
        public static final Type OceanSG2 = new Type("ocean_s_g2");
        private final String name;

        public Type(String s) {
            this.name = s;
            hash.put(s, this);
        }

        public static Type getType(String name) {
            if (name == null) {
                return null;
            }
            return (Type)hash.get(name);
        }

        public String toString() {
            return this.name;
        }
    }
}

