/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.BytePrimitiveVector;
import opendap.dap.ClientIO;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class DByte
extends BaseType
implements ClientIO {
    private byte val;

    public DByte() {
    }

    public DByte(String n) {
        super(n);
    }

    public final byte getValue() {
        return this.val;
    }

    public final void setValue(byte newVal) {
        this.val = newVal;
    }

    @Override
    public PrimitiveVector newPrimitiveVector() {
        return new BytePrimitiveVector(this);
    }

    @Override
    public String getTypeName() {
        return "Byte";
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.println(" = " + (this.val & 0xFF) + ";");
        } else {
            os.print(this.val & 0xFF);
        }
    }

    @Override
    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException {
        for (int i = 0; i < 3; ++i) {
            byte unused = source.readByte();
        }
        this.val = source.readByte();
        if (statusUI != null) {
            statusUI.incrementByteCount(4);
        }
    }

    @Override
    public void externalize(DataOutputStream sink) throws IOException {
        for (int i = 0; i < 3; ++i) {
            sink.writeByte(0);
        }
        sink.writeByte(this.val);
    }
}

