/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.examples.intersection;

import com.terradue.wps_hadoop.common.GML;
import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.n52.wps.io.GTHelper;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectionMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, LongWritable, Text> {
    public String SessionUID;

    public void configure(JobConf job) {
        this.SessionUID = job.get("sessionuid");
    }

    public void map(LongWritable key, Text value, OutputCollector<LongWritable, Text> output, Reporter reporter) throws IOException {
        String line = value.toString();
        ByteArrayInputStream fis = null;
        try {
            fis = new ByteArrayInputStream(line.getBytes("UTF-8"));
            FeatureCollection<SimpleFeatureType, SimpleFeature> polygons = this.getFeatures(fis);
            SimpleFeature polygon = ((SimpleFeature[])polygons.toArray((Object[])new SimpleFeature[polygons.size()]))[0];
            SimpleFeature lineString = ((SimpleFeature[])polygons.toArray((Object[])new SimpleFeature[polygons.size()]))[1];
            Geometry lineStringGeometry = null;
            lineStringGeometry = lineString.getDefaultGeometry() == null && lineString.getAttributeCount() > 0 && lineString.getAttribute(0) instanceof Geometry ? (Geometry)lineString.getAttribute(0) : (Geometry)lineString.getDefaultGeometry();
            Geometry polygonGeometry = (Geometry)polygon.getDefaultGeometry();
            if (lineStringGeometry.isValid()) {
                Geometry intersection = polygonGeometry.intersection(lineStringGeometry);
                SimpleFeature resultFeature = (SimpleFeature)this.createFeature("1_1", intersection, polygon);
                if (resultFeature != null) {
                    output.collect((Object)key, (Object)new Text(this.writeToGML(resultFeature, key)));
                }
            } else {
                output.collect((Object)key, (Object)new Text("Invalid Geometry"));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private String writeToGML(SimpleFeature feature, LongWritable key) {
        try {
            GML encode = new GML(GML.Version.WFS1_0);
            SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
            String fileName = "/store/IMarine/hdfs/outputs/" + this.SessionUID + "/" + key;
            encode.addNamespace(IntersectionMapper.extractNamePart(feature), IntersectionMapper.extractNamespacePart(feature));
            File resultsDir = new File(fileName);
            resultsDir.mkdirs();
            File resultFile = new File(resultsDir, "/result.xml");
            resultFile.createNewFile();
            FileOutputStream xml = new FileOutputStream(resultFile);
            fc.add((Feature)feature);
            encode.encode((OutputStream)xml, fc);
            xml.close();
            return fileName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractNamePart(SimpleFeature feature) {
        String namespaceURI = feature.getType().getName().getNamespaceURI();
        int separatorIndex = namespaceURI.lastIndexOf(47);
        return namespaceURI.substring(++separatorIndex);
    }

    private static String extractNamespacePart(SimpleFeature feature) {
        return feature.getType().getName().getNamespaceURI();
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatures(InputStream is) {
        GML gml = new GML(GML.Version.GML3);
        try {
            SimpleFeatureCollection sfi = gml.decodeFeatureCollection(is);
            return sfi;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Feature createFeature(String id, Geometry geometry, SimpleFeature bluePrint) {
        Feature feature = GTHelper.createFeature((String)id, (Geometry)geometry, (SimpleFeatureType)bluePrint.getFeatureType(), (Collection)bluePrint.getProperties());
        return feature;
    }
}

