/*
 * Decompiled with CFR 0.152.
 */
package org.expressme.openid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.expressme.openid.OpenIdException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    private static final int MAX_SIZE = 10240;
    private static final String CONTENT = "Content";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    Utils() {
    }

    static Map<String, Object> httpRequest(String url, String method, String accept, String formPostData, int timeOutInMilliseconds) {
        HttpURLConnection hc = null;
        InputStream input = null;
        OutputStream output = null;
        try {
            int n;
            hc = (HttpURLConnection)new URL(url).openConnection();
            hc.setRequestMethod(method);
            hc.setDoOutput("POST".equals(method));
            hc.setUseCaches(false);
            hc.setConnectTimeout(timeOutInMilliseconds);
            hc.setReadTimeout(timeOutInMilliseconds);
            hc.addRequestProperty("Accept", accept);
            hc.addRequestProperty("Accept-Encoding", "gzip");
            if (hc.getDoOutput()) {
                output = hc.getOutputStream();
                output.write(formPostData.getBytes("UTF-8"));
                output.flush();
            }
            hc.connect();
            int code = hc.getResponseCode();
            if (code != 200) {
                throw new OpenIdException("Bad response code: " + code);
            }
            boolean gzip = "gzip".equals(hc.getContentEncoding());
            input = hc.getInputStream();
            ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
            boolean overflow = false;
            int read = 0;
            byte[] buffer = new byte[1024];
            while ((n = input.read(buffer)) != -1) {
                byteArrayOutput.write(buffer, 0, n);
                if ((read += n) <= 10240) continue;
                overflow = true;
                break;
            }
            byteArrayOutput.close();
            if (overflow) {
                throw new RuntimeException();
            }
            byte[] data = byteArrayOutput.toByteArray();
            if (gzip) {
                data = Utils.gunzip(data);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Cache-Control", hc.getHeaderField("Cache-Control"));
            map.put("Content-Type", hc.getHeaderField("Content-Type"));
            map.put("Content-Encoding", hc.getHeaderField("Content-Encoding"));
            map.put("Expires", hc.getHeaderField("Expires"));
            map.put(CONTENT, data);
            HashMap<String, Object> hashMap = map;
            return hashMap;
        }
        catch (IOException e) {
            throw new OpenIdException("Request failed: " + url, e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            if (hc != null) {
                hc.disconnect();
            }
        }
    }

    static long getMaxAge(Map<String, Object> map) {
        String cache = (String)map.get("Cache-Control");
        if (cache == null) {
            return 0L;
        }
        int pos = cache.indexOf("max-age=");
        if (pos != -1) {
            String maxAge = cache.substring(pos + "max-age=".length());
            if ((pos = maxAge.indexOf(44)) != -1) {
                maxAge = maxAge.substring(0, pos);
            }
            try {
                return (long)Integer.parseInt(maxAge) * 1000L;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0L;
    }

    static String getContent(Map<String, Object> map) throws UnsupportedEncodingException {
        byte[] data = (byte[])map.get(CONTENT);
        String charset = Utils.getCharset(map);
        if (charset == null) {
            charset = "UTF-8";
        }
        return new String(data, charset);
    }

    public static byte[] gunzip(byte[] data) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream(10240);
        GZIPInputStream input = null;
        try {
            input = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buffer = new byte[1024];
            int n = 0;
            while ((n = input.read(buffer)) > 0) {
                byteOutput.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new OpenIdException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {}
            }
        }
        return byteOutput.toByteArray();
    }

    public static String mid(String s, String startToken, String endToken) {
        return Utils.mid(s, startToken, endToken, 0);
    }

    public static String mid(String s, String startToken, String endToken, int fromStart) {
        if (startToken == null || endToken == null) {
            return null;
        }
        int start = s.indexOf(startToken, fromStart);
        if (start == -1) {
            return null;
        }
        int end = s.indexOf(endToken, start + startToken.length());
        if (end == -1) {
            return null;
        }
        String sub = s.substring(start + startToken.length(), end);
        return sub.trim();
    }

    public static String getCharset(Map<String, Object> map) {
        int pos;
        String contentType = (String)map.get("Content-Type");
        String charset = null;
        if (contentType != null && (pos = contentType.indexOf("charset=")) != -1) {
            charset = contentType.substring(pos + "charset=".length());
            int sp = contentType.indexOf(59);
            if (sp != -1) {
                contentType = contentType.substring(0, sp).trim();
            }
        }
        return charset;
    }

    public static String urlEncode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }

    public static String buildQuery(List<String> list) {
        if (!list.isEmpty()) {
            StringBuilder sb = new StringBuilder(1024);
            try {
                for (String s : list) {
                    int n = s.indexOf(61);
                    sb.append(s.substring(0, n + 1)).append(URLEncoder.encode(s.substring(n + 1), "UTF-8")).append('&');
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            catch (UnsupportedEncodingException e) {
                throw new OpenIdException(e);
            }
            return sb.toString();
        }
        return "";
    }

    public static String toHexString(byte[] bytes) {
        int length = bytes.length;
        StringBuffer sb = new StringBuffer(length * 2);
        int x = 0;
        int n1 = 0;
        int n2 = 0;
        for (int i = 0; i < length; ++i) {
            x = bytes[i] >= 0 ? bytes[i] : 256 + bytes[i];
            n1 = x >> 4;
            n2 = x & 0xF;
            sb = sb.append(HEX[n1]);
            sb = sb.append(HEX[n2]);
        }
        return sb.toString();
    }
}

