/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.jcatalogue.client.download;

import com.terradue.jcatalogue.client.HttpMethod;
import com.terradue.jcatalogue.client.Parameter;
import com.terradue.jcatalogue.client.download.DownloadHandler;
import com.terradue.jcatalogue.client.download.Downloader;
import com.terradue.jcatalogue.client.download.HttpDownloadHandler;
import com.terradue.jcatalogue.client.download.Protocol;
import com.terradue.jcatalogue.client.internal.ahc.HttpInvoker;
import java.beans.ConstructorProperties;
import java.io.File;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(value={"http", "https"})
public final class HttpDownloader
implements Downloader {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpInvoker httpInvoker;

    @Override
    public <T> T download(File targetDir, URI fileUri, DownloadHandler<T> handler) {
        String fileName = fileUri.getPath().substring(fileUri.getPath().lastIndexOf(47) + 1);
        File targetFile = new File(targetDir, fileName);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Downloading {} to {}...", (Object)fileUri, (Object)targetDir);
        }
        try {
            return this.httpInvoker.invoke(HttpMethod.GET, fileUri, new HttpDownloadHandler<T>(targetFile, handler), new Parameter[0]);
        }
        catch (Exception e) {
            handler.onError(e);
            return null;
        }
    }

    @ConstructorProperties(value={"httpInvoker"})
    public HttpDownloader(HttpInvoker httpInvoker) {
        this.httpInvoker = httpInvoker;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpDownloader)) {
            return false;
        }
        HttpDownloader other = (HttpDownloader)o;
        if (this.getLogger() == null ? other.getLogger() != null : !this.getLogger().equals(other.getLogger())) {
            return false;
        }
        return !(this.httpInvoker == null ? other.httpInvoker != null : !this.httpInvoker.equals(other.httpInvoker));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + (this.getLogger() == null ? 0 : this.getLogger().hashCode());
        result = result * 31 + (this.httpInvoker == null ? 0 : this.httpInvoker.hashCode());
        return result;
    }

    public String toString() {
        return "HttpDownloader(logger=" + this.getLogger() + ", httpInvoker=" + this.httpInvoker + ")";
    }
}

