/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.unidata.util.StringUtil;

@Immutable
public class DODSAttribute
extends Attribute {
    private static String[] escapeAttributeStrings = new String[]{"\\", "\""};
    private static String[] substAttributeStrings = new String[]{"\\\\", "\\\""};

    public DODSAttribute(String dodsName, opendap.dap.Attribute att) {
        super(DODSNetcdfFile.makeNetcdfName(dodsName));
        DataType ncType = DODSNetcdfFile.convertToNCType(att.getType());
        int nvals = 0;
        Iterator iter = att.getValuesIterator();
        while (iter.hasNext()) {
            iter.next();
            ++nvals;
        }
        String[] vals = new String[nvals];
        iter = att.getValuesIterator();
        int count = 0;
        while (iter.hasNext()) {
            vals[count++] = (String)iter.next();
        }
        Array data = null;
        if (ncType == DataType.STRING) {
            data = Array.factory(ncType.getPrimitiveClassType(), new int[]{nvals}, (Object)vals);
        } else {
            try {
                data = Array.factory(ncType.getPrimitiveClassType(), new int[]{nvals});
                Index ima = data.getIndex();
                for (int i = 0; i < nvals; ++i) {
                    double dval = Double.parseDouble(vals[i]);
                    data.setDouble(ima.set(i), dval);
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Illegal Numeric Value for Attribute Value for " + dodsName);
            }
        }
        this.setValues(data);
    }

    protected DODSAttribute(String dodsName, String val) {
        super(DODSNetcdfFile.makeNetcdfName(dodsName), val);
    }

    private String unescapeAttributeStringValues(String value) {
        return StringUtil.substitute(value, substAttributeStrings, escapeAttributeStrings);
    }
}

