/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerStatistics;
import org.apache.hadoop.mapred.StatisticsCollector;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;

public final class machines_jsp
extends HttpJspBase
implements JspSourceDependent {
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    public void generateTaskTrackerTable(JspWriter out, String type, JobTracker tracker) throws IOException {
        Collection<TaskTrackerStatus> c;
        if ("blacklisted".equals(type)) {
            out.println("<h2>Blacklisted Task Trackers</h2>");
            c = tracker.blacklistedTaskTrackers();
        } else if ("active".equals(type)) {
            out.println("<h2>Active Task Trackers</h2>");
            c = tracker.activeTaskTrackers();
        } else {
            out.println("<h2>Task Trackers</h2>");
            c = tracker.taskTrackers();
        }
        StatisticsCollector cfr_ignored_0 = tracker.getStatistics().collector;
        int noCols = 9 + 2 * StatisticsCollector.DEFAULT_COLLECT_WINDOWS.length;
        if (type.equals("blacklisted")) {
            ++noCols;
        }
        if (c.size() == 0) {
            out.print("There are currently no known " + type + " Task Trackers.");
        } else {
            out.print("<center>\n");
            out.print("<table class=\"datatable\">\n");
            out.print("<thead>\n");
            out.print("<tr><th align=\"center\" colspan=\"" + noCols + "\"><b>Task Trackers</b></th></tr>\n");
            out.print("<tr><th><b>Name</b></th><th><b>Host</b></th><th><b># running tasks</b></th><th><b>Max Map Tasks</b></th><th><b>Max Reduce Tasks</b></th><th><b>Task Failures</b></th><th><b>Directory Failures</b></th><th><b>Node Health Status</b></th><th><b>Seconds Since Node Last Healthy</b></th>");
            if (type.equals("blacklisted")) {
                out.print("<th><b>Reason For blacklisting</b></th>");
            }
            StatisticsCollector cfr_ignored_1 = tracker.getStatistics().collector;
            for (StatisticsCollector.TimeWindow window : StatisticsCollector.DEFAULT_COLLECT_WINDOWS) {
                out.println("<th><b>Total Tasks " + window.name + "</b></th>");
                out.println("<th><b>Succeeded Tasks " + window.name + "</b></th>");
            }
            out.print("<th><b>Seconds since heartbeat</b></th></tr>\n");
            out.print("</thead><tbody>");
            int maxFailures = 0;
            String failureKing = null;
            for (TaskTrackerStatus tt : c) {
                long sinceHeartbeat = System.currentTimeMillis() - tt.getLastSeen();
                boolean isHealthy = tt.getHealthStatus().isNodeHealthy();
                long sinceHealthCheck = tt.getHealthStatus().getLastReported();
                String healthString = "";
                if (sinceHealthCheck == 0L) {
                    healthString = "N/A";
                } else {
                    healthString = isHealthy ? "Healthy" : "Unhealthy";
                    sinceHealthCheck = System.currentTimeMillis() - sinceHealthCheck;
                    sinceHealthCheck /= 1000L;
                }
                if (sinceHeartbeat > 0L) {
                    sinceHeartbeat /= 1000L;
                }
                int numCurTasks = 0;
                Iterator<TaskStatus> it2 = tt.getTaskReports().iterator();
                while (it2.hasNext()) {
                    it2.next();
                    ++numCurTasks;
                }
                int numTaskFailures = tt.getFailures();
                if (numTaskFailures > maxFailures) {
                    maxFailures = numTaskFailures;
                    failureKing = tt.getTrackerName();
                }
                int numDirFailures = tt.getDirFailures();
                out.print("<tr><td><a href=\"http://");
                out.print(tt.getHost() + ":" + tt.getHttpPort() + "/\">");
                out.print(tt.getTrackerName() + "</a></td><td>");
                out.print(tt.getHost() + "</td><td>" + numCurTasks + "</td><td>" + tt.getMaxMapSlots() + "</td><td>" + tt.getMaxReduceSlots() + "</td><td>" + numTaskFailures + "</td><td>" + numDirFailures + "</td><td>" + healthString + "</td><td>" + sinceHealthCheck);
                if (type.equals("blacklisted")) {
                    out.print("</td><td>" + tracker.getReasonsForBlacklisting(tt.getHost()));
                }
                StatisticsCollector cfr_ignored_2 = tracker.getStatistics().collector;
                for (StatisticsCollector.TimeWindow window : StatisticsCollector.DEFAULT_COLLECT_WINDOWS) {
                    JobTrackerStatistics.TaskTrackerStat ttStat = tracker.getStatistics().getTaskTrackerStat(tt.getTrackerName());
                    out.println("</td><td>" + ttStat.totalTasksStat.getValues().get(window).getValue());
                    out.println("</td><td>" + ttStat.succeededTasksStat.getValues().get(window).getValue());
                }
                out.print("</td><td>" + sinceHeartbeat + "</td></tr>\n");
            }
            out.print("</tbody>\n");
            out.print("</table>\n");
            out.print("</center>\n");
            if (maxFailures > 0) {
                out.print("Highest Failures: " + failureKing + " with " + maxFailures + " failures<br>\n");
            }
        }
    }

    public void generateTableForExcludedNodes(JspWriter out, JobTracker tracker) throws IOException {
        out.println("<h2>Excluded Nodes</h2>");
        Collection<String> d = tracker.getExcludedNodes();
        if (d.size() == 0) {
            out.print("There are currently no excluded hosts.");
        } else {
            out.print("<center>\n");
            out.print("<table border=\"2\" cellpadding=\"5\" cellspacing=\"2\">\n");
            out.print("<tr>");
            out.print("<td><b>Host Name</b></td></tr>\n");
            for (String dt : d) {
                out.print("<td>" + dt + "</td></tr>\n");
            }
            out.print("</table>\n");
            out.print("</center>\n");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        machines_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
            out.write(10);
            out.write(10);
            JobTracker tracker = (JobTracker)application.getAttribute("job.tracker");
            String trackerName = StringUtils.simpleHostname(tracker.getJobTrackerMachine());
            String type = request.getParameter("type");
            out.write(10);
            out.write("\n\n<html>\n<head>\n<title>");
            out.print(trackerName);
            out.write(" Hadoop Machine List</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n</head>\n<body>\n<h1><a href=\"jobtracker.jsp\">");
            out.print(trackerName);
            out.write("</a> Hadoop Machine List</h1>\n\n");
            if ("excluded".equals(type)) {
                this.generateTableForExcludedNodes(out, tracker);
            } else {
                this.generateTaskTrackerTable(out, type, tracker);
            }
            out.write(10);
            out.write(10);
            out.println(ServletUtil.htmlFooter());
            out.write(10);
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof SkipPageException)) {
                    out = _jspx_out;
                    if (out != null && out.getBufferSize() != 0) {
                        out.clearBuffer();
                    }
                    if (_jspx_page_context != null) {
                        _jspx_page_context.handlePageException(t);
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                _jspxFactory.releasePageContext(_jspx_page_context);
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
    }
}

