/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.common;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.wps.x100.CRSsType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.LiteralInputType;
import net.opengis.wps.x100.LiteralOutputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import net.opengis.wps.x100.SupportedCRSsType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.SupportedComplexDataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.Reducer;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.server.AbstractAlgorithm;
import org.n52.wps.server.AbstractSelfDescribingAlgorithm;

public abstract class HadoopAbstractAlgorithm<OK, OV>
extends AbstractSelfDescribingAlgorithm {
    protected final Logger logger = Logger.getLogger(AbstractAlgorithm.class);
    protected Configuration hadoopConfig = new Configuration();
    protected FileSystem hdfs = null;
    protected String hdfsPrefix;

    protected ProcessDescriptionType initializeDescription() {
        String className = ((Object)((Object)this)).getClass().getName().replace(".", "/");
        InputStream xmlDesc = ((Object)((Object)this)).getClass().getResourceAsStream("/" + className + ".xml");
        try {
            XmlOptions option = new XmlOptions();
            option.setLoadTrimTextBuffer();
            ProcessDescriptionsDocument doc = ProcessDescriptionsDocument.Factory.parse((InputStream)xmlDesc, (XmlOptions)option);
            if (doc.getProcessDescriptions().getProcessDescriptionArray().length == 0) {
                return null;
            }
            if (!doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(((Object)((Object)this)).getClass().getName()) && !doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getWellKnownName())) {
                doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().setStringValue(((Object)((Object)this)).getClass().getName());
                System.out.println("Identifier was not correct, was changed now temporary for server use to " + ((Object)((Object)this)).getClass().getName() + ". Please change it later in the description!");
            }
            return doc.getProcessDescriptions().getProcessDescriptionArray(0);
        }
        catch (IOException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + ((Object)((Object)this)).getClass().getName());
        }
        catch (XmlException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + ((Object)((Object)this)).getClass().getName());
        }
        return this.SelfInitializeDescription();
    }

    protected ProcessDescriptionType SelfInitializeDescription() {
        ProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();
        ProcessDescriptionsDocument.ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();
        ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();
        processDescription.setStatusSupported(true);
        processDescription.setStoreSupported(true);
        processDescription.setProcessVersion("1.0.0");
        processDescription.addNewIdentifier().setStringValue(((Object)((Object)this)).getClass().getName());
        processDescription.addNewTitle().setStringValue(((Object)((Object)this)).getClass().getCanonicalName());
        List identifiers = this.getInputIdentifiers();
        ProcessDescriptionType.DataInputs dataInputs = null;
        if (identifiers.size() > 0) {
            dataInputs = processDescription.addNewDataInputs();
        }
        for (String identifier : identifiers) {
            Class<?>[] interfaces;
            InputDescriptionType dataInput = dataInputs.addNewInput();
            dataInput.setMinOccurs(this.getMinOccurs(identifier));
            dataInput.setMaxOccurs(this.getMaxOccurs(identifier));
            dataInput.addNewIdentifier().setStringValue(identifier);
            dataInput.addNewTitle().setStringValue(identifier);
            Class inputDataTypeClass = this.getInputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = inputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralInputType literalData = dataInput.addNewLiteralData();
                    String inputClassType = "";
                    for (Constructor<?> constructor : constructors = inputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        inputClassType = parameters[0].getSimpleName();
                    }
                    if (inputClassType.length() <= 0) continue;
                    DomainMetadataType datatype = literalData.addNewDataType();
                    datatype.setReference("xs:" + inputClassType.toLowerCase());
                    literalData.addNewAnyValue();
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataInput.addNewBoundingBoxData();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXInput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataInputType complexData = dataInput.addNewComplexData();
                List parsers = ParserFactory.getInstance().getAllParsers();
                ArrayList<IParser> foundParsers = new ArrayList<IParser>();
                for (IParser parser : parsers) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = parser.getSupportedDataBindings()) {
                        if (!clazz.equals(inputDataTypeClass)) continue;
                        foundParsers.add(parser);
                    }
                }
            }
        }
        ProcessDescriptionType.ProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();
        List outputIdentifiers = this.getOutputIdentifiers();
        for (String identifier : outputIdentifiers) {
            Class<?>[] interfaces;
            OutputDescriptionType dataOutput = dataOutputs.addNewOutput();
            dataOutput.addNewIdentifier().setStringValue(identifier);
            dataOutput.addNewTitle().setStringValue(identifier);
            dataOutput.addNewAbstract().setStringValue(identifier);
            Class outputDataTypeClass = this.getOutputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = outputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralOutputType literalData = dataOutput.addNewLiteralOutput();
                    String outputClassType = "";
                    for (Constructor<?> constructor : constructors = outputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        outputClassType = parameters[0].getSimpleName();
                    }
                    if (outputClassType.length() <= 0) continue;
                    literalData.addNewDataType().setReference("xs:" + outputClassType.toLowerCase());
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataOutput.addNewBoundingBoxOutput();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXOutput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataType complexData = dataOutput.addNewComplexOutput();
                List generators = GeneratorFactory.getInstance().getAllGenerators();
                ArrayList<IGenerator> foundGenerators = new ArrayList<IGenerator>();
                for (IGenerator generator : generators) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = generator.getSupportedDataBindings()) {
                        if (!clazz.equals(outputDataTypeClass)) continue;
                        foundGenerators.add(generator);
                    }
                }
            }
        }
        return document.getProcessDescriptions().getProcessDescriptionArray(0);
    }

    protected abstract Class<? extends Mapper<?, ?, OK, OV>> getMapper();

    protected Class<? extends Reducer<OK, OV, ?, ?>> getReducer() {
        return null;
    }

    protected abstract JobConf getJobConf();

    protected abstract String getJobName();

    protected abstract Path[] getInputPaths(Map<String, List<IData>> var1);

    protected abstract String getOutputPath();

    public final Map<String, IData> run(Map<String, List<IData>> inputData) {
        this.prepareToRun(inputData);
        this.logger.info((Object)"Getting JobConf");
        this.hadoopConfig.set("io.sort.mb", "20");
        JobConf conf = this.getJobConf();
        if (conf == null) {
            conf = new JobConf(this.hadoopConfig);
        }
        this.logger.info((Object)"Setting JobName");
        conf.setJobName(this.getJobName());
        this.logger.info((Object)"getting Mapper Class");
        conf.setMapperClass(this.getMapper());
        if (this.getReducer() != null) {
            this.logger.info((Object)"getting Reducer Class");
            conf.setReducerClass(this.getReducer());
        }
        this.logger.info((Object)"Setting Input Paths ");
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{this.getInputPaths(inputData)[0]});
        this.logger.info((Object)("getting OutputPath " + this.getOutputPath()));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(this.getOutputPath()));
        try {
            this.logger.info((Object)"Running Job...");
            JobClient.runJob((JobConf)conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Error accessing to Input/Output Path", e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.info((Object)"Building results");
        return this.buildResults();
    }

    protected void prepareToRun(Map<String, List<IData>> inputData) {
    }

    protected abstract Map<String, IData> buildResults();
}

