/*
 * Decompiled with CFR 0.152.
 */
package com.terradue.wps_hadoop.processes.examples.async;

import com.terradue.wps_hadoop.common.input.InputUtils;
import com.terradue.wps_hadoop.streaming.ExecutionResultsInfo;
import com.terradue.wps_hadoop.streaming.ResultsInfo;
import com.terradue.wps_hadoop.streaming.WpsHadoopConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.wps.x100.CRSsType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.LiteralInputType;
import net.opengis.wps.x100.LiteralOutputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import net.opengis.wps.x100.SupportedCRSsType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.SupportedComplexDataType;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractSelfDescribingAlgorithm;

public class Async
extends AbstractSelfDescribingAlgorithm {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private List<String> errors = new ArrayList<String>();

    public Map<String, IData> run(Map<String, List<IData>> inputData) {
        int secondsDelay = InputUtils.getIntegerInputParameter(inputData, "secondsDelay", true);
        this.logger.info((Object)"Running Job TEST ASYNC...");
        WpsHadoopConfiguration conf = new WpsHadoopConfiguration();
        String jobId = UUID.randomUUID().toString();
        ResultsInfo result = new ResultsInfo(conf, jobId, "Async");
        System.out.println("\nSTART...");
        try {
            for (int i = 0; i < secondsDelay; ++i) {
                System.out.println(i + " - (" + 100 * i / secondsDelay + "%)");
                this.update("" + 100 * i / secondsDelay);
                if ((secondsDelay == 3 || secondsDelay == 20) && 100 * i / secondsDelay > 80) {
                    throw new RuntimeException("Y!!!ou have inserted 3 or 20 seconds");
                }
                Thread.sleep(998L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("END...\n");
        ExecutionResultsInfo executionResults = new ExecutionResultsInfo();
        executionResults.setInputDataUrl("https://dl.dropboxusercontent.com/u/24368142/es.txt");
        executionResults.addOutputUrl("http://www.letsgomobile.org/images/reviews/0102/samsung-camera-phone-test-pictures.jpg");
        executionResults.addOutputUrl("http://images.fineartamerica.com/images-medium-large/tv-multicolor-signal-test-pattern-aloysius-patrimonio.jpg");
        executionResults.addOutputUrl("http://www.massmurdermedia.tv/images/TV%20Test%20Pattern%2006.jpg");
        result.addExecutionResults(executionResults);
        HashMap<String, IData> wpsResultMap = new HashMap<String, IData>();
        wpsResultMap.put("result", (IData)result.getXmlFileDataBinding());
        return wpsResultMap;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Class<?> getInputDataType(String id) {
        return LiteralStringBinding.class;
    }

    public Class<?> getOutputDataType(String id) {
        if (id.contentEquals("result")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("secondsDelay");
        return identifierList;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> identifierList = new ArrayList<String>();
        identifierList.add("result");
        return identifierList;
    }

    protected ProcessDescriptionType initializeDescription() {
        String className = ((Object)((Object)this)).getClass().getName().replace(".", "/");
        InputStream xmlDesc = ((Object)((Object)this)).getClass().getResourceAsStream("/" + className + ".xml");
        try {
            XmlOptions option = new XmlOptions();
            option.setLoadTrimTextBuffer();
            ProcessDescriptionsDocument doc = ProcessDescriptionsDocument.Factory.parse((InputStream)xmlDesc, (XmlOptions)option);
            if (doc.getProcessDescriptions().getProcessDescriptionArray().length == 0) {
                return null;
            }
            if (!doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(((Object)((Object)this)).getClass().getName()) && !doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().getStringValue().equals(this.getWellKnownName())) {
                doc.getProcessDescriptions().getProcessDescriptionArray(0).getIdentifier().setStringValue(((Object)((Object)this)).getClass().getName());
                System.out.println("Identifier was not correct, was changed now temporary for server use to " + ((Object)((Object)this)).getClass().getName() + ". Please change it later in the description!");
            }
            return doc.getProcessDescriptions().getProcessDescriptionArray(0);
        }
        catch (IOException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + ((Object)((Object)this)).getClass().getName());
        }
        catch (XmlException e) {
            System.out.println("Could not initialize algorithm, parsing error: " + ((Object)((Object)this)).getClass().getName());
        }
        return this.SelfInitializeDescription();
    }

    protected ProcessDescriptionType SelfInitializeDescription() {
        ProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();
        ProcessDescriptionsDocument.ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();
        ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();
        processDescription.setStatusSupported(true);
        processDescription.setStoreSupported(true);
        processDescription.setProcessVersion("1.0.0");
        processDescription.addNewIdentifier().setStringValue(((Object)((Object)this)).getClass().getName());
        processDescription.addNewTitle().setStringValue(((Object)((Object)this)).getClass().getCanonicalName());
        List<String> identifiers = this.getInputIdentifiers();
        ProcessDescriptionType.DataInputs dataInputs = null;
        if (identifiers.size() > 0) {
            dataInputs = processDescription.addNewDataInputs();
        }
        for (String identifier : identifiers) {
            Class<?>[] interfaces;
            InputDescriptionType dataInput = dataInputs.addNewInput();
            dataInput.setMinOccurs(this.getMinOccurs(identifier));
            dataInput.setMaxOccurs(this.getMaxOccurs(identifier));
            dataInput.addNewIdentifier().setStringValue(identifier);
            dataInput.addNewTitle().setStringValue(identifier);
            Class<?> inputDataTypeClass = this.getInputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = inputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralInputType literalData = dataInput.addNewLiteralData();
                    String inputClassType = "";
                    for (Constructor<?> constructor : constructors = inputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        inputClassType = parameters[0].getSimpleName();
                    }
                    if (inputClassType.length() <= 0) continue;
                    DomainMetadataType datatype = literalData.addNewDataType();
                    datatype.setReference("xs:" + inputClassType.toLowerCase());
                    literalData.addNewAnyValue();
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataInput.addNewBoundingBoxData();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXInput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataInputType complexData = dataInput.addNewComplexData();
                List parsers = ParserFactory.getInstance().getAllParsers();
                ArrayList<IParser> foundParsers = new ArrayList<IParser>();
                for (IParser parser : parsers) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = parser.getSupportedDataBindings()) {
                        if (!clazz.equals(inputDataTypeClass)) continue;
                        foundParsers.add(parser);
                    }
                }
            }
        }
        ProcessDescriptionType.ProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();
        List<String> outputIdentifiers = this.getOutputIdentifiers();
        for (String identifier : outputIdentifiers) {
            Class<?>[] interfaces;
            OutputDescriptionType dataOutput = dataOutputs.addNewOutput();
            dataOutput.addNewIdentifier().setStringValue(identifier);
            dataOutput.addNewTitle().setStringValue(identifier);
            dataOutput.addNewAbstract().setStringValue(identifier);
            Class<?> outputDataTypeClass = this.getOutputDataType(identifier);
            for (Class<?> implementedInterface : interfaces = outputDataTypeClass.getInterfaces()) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralOutputType literalData = dataOutput.addNewLiteralOutput();
                    String outputClassType = "";
                    for (Constructor<?> constructor : constructors = outputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        outputClassType = parameters[0].getSimpleName();
                    }
                    if (outputClassType.length() <= 0) continue;
                    literalData.addNewDataType().setReference("xs:" + outputClassType.toLowerCase());
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataOutput.addNewBoundingBoxOutput();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXOutput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataType complexData = dataOutput.addNewComplexOutput();
                List generators = GeneratorFactory.getInstance().getAllGenerators();
                ArrayList<IGenerator> foundGenerators = new ArrayList<IGenerator>();
                for (IGenerator generator : generators) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = generator.getSupportedDataBindings()) {
                        if (!clazz.equals(outputDataTypeClass)) continue;
                        foundGenerators.add(generator);
                    }
                }
            }
        }
        return document.getProcessDescriptions().getProcessDescriptionArray(0);
    }

    public static void main(String[] args) {
    }
}

