/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin.repository.iterators;

import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gcube.data.figis.tmplugin.dbconnection.FigisTable;
import org.gcube.data.figis.tmplugin.repository.iterators.FigisRecord;
import org.gcube.data.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordIterator
implements Stream<FigisRecord> {
    private static Logger log = LoggerFactory.getLogger(RecordIterator.class);
    ResultSet rs = null;
    Boolean finished = false;
    Boolean closed = false;

    public RecordIterator() {
        log.trace("Iterator Figis Records");
        try {
            FigisTable figisTable = new FigisTable();
            this.rs = figisTable.getAllRecords();
        }
        catch (Exception e) {
            log.error("Error creating FigisRecord iterator", (Throwable)e);
        }
    }

    public void remove() {
    }

    public boolean hasNext() {
        try {
            this.finished = !this.rs.next();
        }
        catch (SQLException e) {
            log.error("sql Error", (Throwable)e);
        }
        if (this.finished.booleanValue()) {
            this.close();
        }
        return this.finished == false;
    }

    public FigisRecord next() {
        FigisRecord record = null;
        try {
            record = new FigisRecord(this.rs);
        }
        catch (Exception e) {
            log.error("Error retrieving next FigisRecord", (Throwable)e);
        }
        return record;
    }

    public URI locator() {
        return null;
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException ex) {
            log.error("sql Error", (Throwable)ex);
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

