/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.figis.tmplugin.dbconnection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.gcube.data.figis.tmplugin.FigisPlugin;
import org.gcube.data.figis.tmplugin.dbconnection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static Logger log = LoggerFactory.getLogger(ConnectionPool.class);
    public static String dbJdbc;
    private static String dbDriver;
    private static String dbLogin;
    private static String dbPassword;
    private static ConnectionPool connectionPool;
    private Vector<Connection> freeConnections;

    private ConnectionPool() throws ConnectionPoolException {
        this.loadParameters();
        this.freeConnections = new Vector();
        this.loadDriver();
    }

    private void loadParameters() {
        dbJdbc = FigisPlugin.jdbc;
        dbLogin = FigisPlugin.dbLogin;
        dbPassword = FigisPlugin.dbPassword;
        dbDriver = "org.postgresql.Driver";
    }

    private void loadDriver() throws ConnectionPoolException {
        try {
            Class.forName(dbDriver).newInstance();
        }
        catch (Exception e) {
            throw new ConnectionPoolException();
        }
    }

    public static synchronized ConnectionPool getConnectionPool() throws ConnectionPoolException {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool();
        }
        return connectionPool;
    }

    public synchronized Connection getConnection() throws ConnectionPoolException, SQLException {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                con = this.getConnection();
            }
        } else if (this.freeConnections.size() < 100) {
            con = this.newConnection();
        }
        return con;
    }

    private Connection newConnection() throws ConnectionPoolException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(dbJdbc, dbLogin, dbPassword);
        }
        catch (SQLException e) {
            throw new ConnectionPoolException();
        }
        return con;
    }

    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.add(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preStatement(String query, ArrayList<String> terms, PreparedStatement stmt) {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            for (int i = 0; i < terms.size(); ++i) {
                stmt.setString(i + 1, terms.get(i));
            }
            stmt.executeUpdate();
            stmt.clearParameters();
        }
        catch (SQLException sqle) {
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertPreStatement(String query) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            stmt.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet selectPreStatement(String query) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            result = stmt.executeQuery();
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet selectPrestatement(String query, String term) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet result = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            stmt.setString(1, term);
            result = stmt.executeQuery();
        }
        catch (SQLException e) {
            log.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            log.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return result;
    }

    static {
        connectionPool = null;
    }
}

