/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.fishfinder.tmplugin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.gcube.data.fishfinder.tmplugin.FishFinderPlugin;
import org.gcube.data.fishfinder.tmplugin.FishFinderReader;
import org.gcube.data.fishfinder.tmplugin.FishFinderSource;
import org.gcube.data.fishfinder.tmplugin.Lifecycle;
import org.gcube.data.fishfinder.tmplugin.ProductionProvider;
import org.gcube.data.fishfinder.tmplugin.RepositoryProvider;
import org.gcube.data.fishfinder.tmplugin.repository.Repository;
import org.gcube.data.fishfinder.tmplugin.requests.FishFinderRequest;
import org.gcube.data.fishfinder.tmplugin.requests.RequestBinder;
import org.gcube.data.fishfinder.tmplugin.utils.Utils;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class FishFinderBinder
implements SourceBinder {
    private static Logger log = LoggerFactory.getLogger(FishFinderBinder.class);
    private RepositoryProvider provider;

    public FishFinderBinder() {
        this(new ProductionProvider());
        log.trace("FishFinderBinder");
    }

    FishFinderBinder(RepositoryProvider p) {
        this.provider = p;
    }

    public List<? extends FishFinderSource> bind(Element request) throws InvalidRequestException, Exception {
        if (FishFinderPlugin.jdbc == null || FishFinderPlugin.dbLogin == null || FishFinderPlugin.dbPassword == null || FishFinderPlugin.baseUrl == null || FishFinderPlugin.extractAllCsv == null || FishFinderPlugin.reinitialize == null) {
            Utils.getRuntimeResource();
        }
        Utils.createTableUpdates();
        Utils.createTableFigis();
        FishFinderRequest fishFinderRequestRequest = new RequestBinder().bind(request);
        Repository repository = this.provider.newRepository(fishFinderRequestRequest);
        FishFinderSource source = new FishFinderSource(UUID.randomUUID().toString());
        source.setName(fishFinderRequestRequest.getName());
        source.setDescription(fishFinderRequestRequest.getDescription());
        source.setReader((SourceReader)new FishFinderReader(source, repository));
        source.setLifecycle((SourceLifecycle)new Lifecycle(source));
        log.trace("created source {}" + source.id());
        return Collections.singletonList(source);
    }
}

