package org.gcube.data.fishfinder.tmplugin.requests;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * A {@link Request} to bind the OAI Plugin to a single data source formed of all the records in one ore more sets of an OAI repository.
 *  
 * @author "Valentina Marioli valentina.marioli@isti.cnr.it"
 *
 */
@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class FishFinderRequest extends Request implements Serializable{

	private static final long serialVersionUID = 1L;

	/**
	 * Creates an instance
	 */
	
	public FishFinderRequest() {
	}

	@Override
	public int hashCode() {
		int result = super.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {		
		
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;		
		
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("FishFinderRequest [name=");
		builder.append(super.getName());
		builder.append(", description=");
		builder.append(super.getDescription());
		builder.append("]");
		return builder.toString();
	}


}
