package org.gcube.data.harmonization.occurrence.db.model;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.operating.OperatingModuleConfiguration;
import org.gcube.data.harmonization.occurrence.util.Utils;

import com.j256.ormlite.field.DatabaseField;
import com.thoughtworks.xstream.XStream;

/**
 * @author fabio
 *
 */
public abstract class ExecutionReference {

	protected static GCUBELog logger = new GCUBELog(OperatingModuleConfiguration.class);
	
	public abstract static class ExecutionRequest{
		private GCUBEScope scope;
		private String author;
		public ExecutionRequest(GCUBEScope scope, String author) {
			super();
			this.scope = scope;
			this.author = author;
		}
		public String getAuthor() {
			return author;
		}
		public GCUBEScope getScope() {
			return scope;
		}
	}
	
	
	//***************** TABLE FIELDS
	
	public static final String ID_FIELD="id";
	
	public static final String SUBMISSION_FIELD="submissiontime";
	
	public static final String START_FIELD="starttime";
	
	public static final String COMPLETION_FIELD="completiontime";
	
	public static final String AUTHOR_FIELD="author";
	
	public static final String STATE_FIELD="state";
	
	public static final String SCOPE_FIELD="scope";
	
	public static final String PROGRESS_FIELD="progress";
	
	
	
	@DatabaseField(id=true, width=70, columnName=ExecutionReference.ID_FIELD)
	private String id; 
	
	@DatabaseField(canBeNull=false,columnName=ExecutionReference.SUBMISSION_FIELD)
	private Long submissionTime;
	
	@DatabaseField(defaultValue="0",columnName=ExecutionReference.START_FIELD)
	private Long startTime=0l;
	
	@DatabaseField(defaultValue="0",columnName=ExecutionReference.COMPLETION_FIELD)
	private Long completionTime=0l;

	
	@DatabaseField(canBeNull=false, width=100,columnName=ExecutionReference.AUTHOR_FIELD)
	private String author;

	@DatabaseField(canBeNull=false, width=30,columnName=ExecutionReference.STATE_FIELD)
	private ExecutionState state=ExecutionState.NEW;
	
	@DatabaseField(canBeNull=false, width=150,columnName=ExecutionReference.SCOPE_FIELD)
    private String scope;


	@DatabaseField(canBeNull=false, defaultValue="0", columnName=PROGRESS_FIELD)
	private Double progress=0d;
	
	
	public abstract void updateStatus(ExecutionState toSet)throws Exception;
	
	
	public ExecutionReference(ExecutionRequest request){
		setId(Utils.generateId("", ""));
		setStartTime(0l);
		setCompletionTime(0l);
		setSubmissionTime(System.currentTimeMillis());
		setAuthor(request.getAuthor());
		setProgress(0d);
		setScope(request.getScope()+"");
		setState(ExecutionState.NEW);		
	}
	
	public ExecutionReference() {
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the submissionTime
	 */
	public Long getSubmissionTime() {
		return submissionTime;
	}

	/**
	 * @param submissionTime the submissionTime to set
	 */
	public void setSubmissionTime(Long submissionTime) {
		this.submissionTime = submissionTime;
	}

	/**
	 * @return the startTime
	 */
	public Long getStartTime() {
		return startTime;
	}

	/**
	 * @param startTime the startTime to set
	 */
	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}

	/**
	 * @return the completionTime
	 */
	public Long getCompletionTime() {
		return completionTime;
	}

	/**
	 * @param completionTime the completionTime to set
	 */
	public void setCompletionTime(Long completionTime) {
		this.completionTime = completionTime;
	}

	/**
	 * @return the author
	 */
	public String getAuthor() {
		return author;
	}

	/**
	 * @param author the author to set
	 */
	public void setAuthor(String author) {
		this.author = author;
	}

	/**
	 * @return the state
	 */
	public ExecutionState getState() {
		return state;
	}

	/**
	 * @param state the state to set
	 */
	public void setState(ExecutionState state) {
		this.state = state;
	}

	/**
	 * @return the scope
	 */
	public String getScope() {
		return scope;
	}

	/**
	 * @param scope the scope to set
	 */
	public void setScope(String scope) {
		this.scope = scope;
	}

	
	/**
	 * @return the progress
	 */
	public Double getProgress() {
		return progress;
	}

	/**
	 * @param progress the progress to set
	 */
	public void setProgress(Double progress) {
		this.progress = progress;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ExecutionReference other = (ExecutionReference) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ExecutionReference [id=");
		builder.append(id);
		builder.append(", submissionTime=");
		builder.append(submissionTime);
		builder.append(", startTime=");
		builder.append(startTime);
		builder.append(", completionTime=");
		builder.append(completionTime);
		builder.append(", author=");
		builder.append(author);
		builder.append(", state=");
		builder.append(state);
		builder.append(", scope=");
		builder.append(scope);
		builder.append("]");
		return builder.toString();
	}
	
}
