package org.gcube.data.harmonization.occurrence.db.model;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;

import org.apache.commons.io.IOUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;
import org.gcube.data.harmonization.occurrence.stubs.ImportType;
import org.gcube.data.harmonization.occurrence.stubs.utils.RSWrapper;

import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.table.DatabaseTable;


@DatabaseTable
public class ImportReference extends ExecutionReference {

	
	public static class ImportRequest extends ExecutionReference.ExecutionRequest{
		private String toReadStream;
		private ImportType type;
		public ImportRequest(GCUBEScope scope, String author,
				String toReadStream, ImportType type) {
			super(scope, author);
			this.toReadStream = toReadStream;
			this.type = type;
		}
		public String getToReadStream() {
			return toReadStream;
		}
		public ImportType getType() {
			return type;
		}
	}
	
	
	public static final String STREAM_FIELD="stream";
	public static final String PERSISTENCE_FIELD="persistence";
	public static final String TO_MERGE_FIELD="merge_id";

	public static final String IMPORT_TYPE_FILED="type";


	@DatabaseField(canBeNull=false, dataType=DataType.STRING_BYTES, columnName=ImportReference.STREAM_FIELD)
	private String streamUri;

	@DatabaseField(dataType=DataType.STRING_BYTES, columnName=ImportReference.PERSISTENCE_FIELD)
	private String persistenceUri;

	@ForeignCollectionField(eager=false, columnName=TO_MERGE_FIELD)
	private ForeignCollection<ToMergeImported> toMergeImportedReferences;


	@DatabaseField(canBeNull=false, columnName=IMPORT_TYPE_FILED,dataType=DataType.SERIALIZABLE)
	private ImportType type;


	public ImportReference(ImportRequest request)throws Exception{
		super(request);
		setState(ExecutionState.READY);
		setType(request.getType());
		if(getType().equals(ImportType.MANUAL_UPLOAD)){
			FileOutputStream fos=null;
			try{
				File localFile=File.createTempFile("manual", "");
				fos=new FileOutputStream(localFile);
				IOUtils.copy(new FileInputStream(RSWrapper.getStreamFromLocator(new URI(request.getToReadStream()))), fos);
				setStreamUri(localFile.getAbsolutePath());
			}catch(Exception e){
				logger.error("Unexpected error while copying data from RS, uri was "+request.getToReadStream(),e);
				throw new Exception("Unable to copy data");
			}finally{
				if(fos!=null) IOUtils.closeQuietly(fos);
			}
		}
		logger.debug("Going to insert "+this);
		ServiceContext.getContext().getImportDao().create(this);
	}
	
	public ImportReference() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @return the toMergeImportedReferences
	 */
	public ForeignCollection<ToMergeImported> getToMergeImportedReferences() {
		return toMergeImportedReferences;
	}
	/**
	 * @param toMergeImportedReferences the toMergeImportedReferences to set
	 */
	public void setToMergeImportedReferences(
			ForeignCollection<ToMergeImported> toMergeImportedReferences) {
		this.toMergeImportedReferences = toMergeImportedReferences;
	}
	/**
	 * @return the type
	 */
	public ImportType getType() {
		return type;
	}
	/**
	 * @param type the type to set
	 */
	public void setType(ImportType type) {
		this.type = type;
	}
	/**
	 * @return the streamUri
	 */
	public String getStreamUri() {
		return streamUri;
	}
	/**
	 * @param streamUri the streamUri to set
	 */
	public void setStreamUri(String streamUri) {
		this.streamUri = streamUri;
	}
	/**
	 * @return the persistenceUri
	 */
	public String getPersistenceUri() {
		return persistenceUri;
	}
	/**
	 * @param persistenceUri the persistenceUri to set
	 */
	public void setPersistenceUri(String persistenceUri) {
		this.persistenceUri = persistenceUri;
	}



	/* (non-Javadoc)
	 * @see org.gcube.dataharmonization.occurrencereconciliation.impl.model.ExecutionReference#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {		
		return super.equals(obj);
	}

	/* (non-Javadoc)
	 * @see org.gcube.dataharmonization.occurrencereconciliation.impl.model.ExecutionReference#hashCode()
	 */
	@Override
	public int hashCode() {
		// TODO Auto-generated method stub
		return super.hashCode();
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImportReference [streamUri=");
		builder.append(streamUri);
		builder.append(", persistenceUri=");
		builder.append(persistenceUri);		
		builder.append(", getId()=");
		builder.append(getId());
		builder.append(", getSubmissionTime()=");
		builder.append(getSubmissionTime());
		builder.append(", getStartTime()=");
		builder.append(getStartTime());
		builder.append(", getCompletionTime()=");
		builder.append(getCompletionTime());
		builder.append(", getAuthor()=");
		builder.append(getAuthor());
		builder.append(", getState()=");
		builder.append(getState());
		builder.append(", getScope()=");
		builder.append(getScope());
		builder.append(", getProgress()=");
		builder.append(getProgress());
		builder.append("]");
		return builder.toString();
	}

	@Override
	public void updateStatus(ExecutionState toSet) throws Exception {
		//Updates reference
		setState(toSet);
		if(toSet.equals(ExecutionState.STARTED)) 
			setStartTime(System.currentTimeMillis());
		else if(toSet.equals(ExecutionState.COMPLETED)||toSet.equals(ExecutionState.ERROR))
			setCompletionTime(System.currentTimeMillis());
		ServiceContext.getContext().getImportDao().update(this);


		//update Merge references
		if(toSet.equals(ExecutionState.COMPLETED)||toSet.equals(ExecutionState.ERROR)){
			logger.debug("Status setted was "+toSet+", notifying related mergeReference");

			ExecutionState mergeState=toSet.equals(ExecutionState.COMPLETED)?ExecutionState.READY:ExecutionState.ERROR;

			PreparedQuery<MergeReference> mergeQuery=null;
			CloseableWrappedIterable<MergeReference> mergeIterator=null;
			try{
				mergeQuery=ToMergeImported.getMergePerImportPreparedQuery();
				mergeQuery.setArgumentHolderValue(0, this);
				mergeIterator=ServiceContext.getContext().getMergeDao().getWrappedIterable(mergeQuery);

				PreparedQuery<ImportReference> importQuery=ToMergeImported.getImportPerMergePreparedQuery();
				CloseableWrappedIterable<ImportReference> importIterator=null;

				for(MergeReference merge:mergeIterator){
					if(merge.getState().equals(ExecutionState.NEW)){ // Only waiting merge need to be checked
						if(mergeState.equals(ExecutionState.READY)){						
							try{
								boolean ready=true;
								importQuery.setArgumentHolderValue(0, merge);
								importIterator=ServiceContext.getContext().getImportDao().getWrappedIterable(importQuery);
								for(ImportReference importRef: importIterator){
									if(!importRef.getState().equals(ExecutionState.COMPLETED)){
										ready=false;
										break;
									}
								}
								if(ready)merge.updateStatus(mergeState);
							}catch(Exception e){
								merge.updateStatus(ExecutionState.ERROR);
								throw e;
							}finally{
								if(importIterator!=null) importIterator.close();
							}
						}
					}
				}
			}catch(Exception e){
				throw e;
			}finally{
				if(mergeIterator!=null)mergeIterator.close();
			}
		}
	}

}
