package org.gcube.data.harmonization.occurrence.db.model;

import java.sql.SQLException;

import org.gcube.data.harmonization.occurrence.services.ServiceContext;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.table.DatabaseTable;


@DatabaseTable
public class ToMergeImported extends BaseDaoEnabled<ToMergeImported, String>{

	public static final String IMPORTED_ID="import_id";
	public static final String MERGE_ID="merge_id";

	
	@DatabaseField(foreign=true,columnName=IMPORTED_ID)
	private ImportReference importReference;
	
	@DatabaseField(foreign=true,columnName=MERGE_ID)
	private MergeReference mergeReference;
	
	@DatabaseField(generatedId=true)
	private Integer id;
	
	public ToMergeImported() {
		// TODO Auto-generated constructor stub
	}
	
	public ToMergeImported(ImportReference importReference,MergeReference mergeReference) {
		this.importReference=importReference;
		this.mergeReference=mergeReference;
	}

	/**
	 * @return the importReference
	 */
	public ImportReference getImportReference() {
		return importReference;
	}

	/**
	 * @param importReference the importReference to set
	 */
	public void setImportReference(ImportReference importReference) {
		this.importReference = importReference;
	}

	/**
	 * @return the mergeReference
	 */
	public MergeReference getMergeReference() {
		return mergeReference;
	}

	/**
	 * @param mergeReference the mergeReference to set
	 */
	public void setMergeReference(MergeReference mergeReference) {
		this.mergeReference = mergeReference;
	}

	/**
	 * @return the id
	 */
	public Integer getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Integer id) {
		this.id = id;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ToMergeImported other = (ToMergeImported) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ToMergeImported [importReference=");
		builder.append(importReference);
		builder.append(", mergeReference=");
		builder.append(mergeReference);
		builder.append(", id=");
		builder.append(id);
		builder.append("]");
		return builder.toString();
	}
	
	
	public static PreparedQuery<MergeReference> getMergePerImportPreparedQuery() throws SQLException{
		//INNER QUERY
		QueryBuilder<ToMergeImported,Integer> mergeImportQb=ServiceContext.getContext().getToMergeDao().queryBuilder();
		mergeImportQb.selectColumns(MERGE_ID);
		mergeImportQb.where().eq(IMPORTED_ID, new SelectArg());
		
		//OUTER QUERY
		QueryBuilder<MergeReference,String> mergeQb=ServiceContext.getContext().getMergeDao().queryBuilder();
		mergeQb.where().in(MergeReference.ID_FIELD, mergeImportQb);
		return mergeQb.prepare();
	}
	
	
	public static PreparedQuery<ImportReference> getImportPerMergePreparedQuery()throws SQLException{
		//INNER QUERY
		QueryBuilder<ToMergeImported,Integer> mergeImportQb=ServiceContext.getContext().getToMergeDao().queryBuilder();
		mergeImportQb.selectColumns(IMPORTED_ID);
		mergeImportQb.where().eq(MERGE_ID, new SelectArg());
		
		//OUTER QUERY
		QueryBuilder<ImportReference,String> importQb=ServiceContext.getContext().getImportDao().queryBuilder();
		importQb.where().in(ImportReference.ID_FIELD, mergeImportQb);
		return importQb.prepare();
	}
	
}
