package org.gcube.data.harmonization.occurrence.operating;

import java.util.concurrent.atomic.AtomicInteger;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.queue.QueueReceiver;

public class ImportHandler extends QueueReceiver {
	
	private static GCUBELog logger = new GCUBELog(ImportHandler.class);
	
	private static AtomicInteger instanceCount=new AtomicInteger(0);
	
	public ImportHandler(){
		super();
		this.setName("IMPORT_"+instanceCount.incrementAndGet());
	}

	@Override
	public void handleMessage() throws Exception {
		logger.debug("Handling request, message is "+currentMessage);
		try{
			Thread.sleep(2*1000);
		}catch(InterruptedException e){			
		}
		logger.debug("Throwing exception just for test..");
		throw new Exception("Fake execution");
	}

	@Override
	public void rollback() throws Exception {
		logger.debug("Rollbacking execution...");
		try{
			Thread.sleep(2*1000);
		}catch(InterruptedException e){			
		}
	}

	@Override
	public void cleanup() {
		logger.debug("Cleaning it up..");
	}

	
}
