package org.gcube.data.harmonization.occurrence.operating;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference.ExecutionRequest;
import org.gcube.data.harmonization.occurrence.queue.QueueReceiver;
import org.gcube.data.harmonization.occurrence.queue.QueueSender;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

public class OperatingModule<U extends ExecutionReference, T extends QueueReceiver> {

	private static GCUBELog logger = new GCUBELog(OperatingModule.class);

	private Connection connection;

	private OperatingModuleConfiguration<U,T> configuration;

	public void init(OperatingModuleConfiguration<U,T> configuration) throws Exception{
		logger.debug("Initializing Operating Module ("+configuration.getHanlderClass().getName()+"), passed configuration "+configuration);
		this.configuration=configuration;
		// Creating connection to queue..
		ConnectionFactory connectionFactory=new ConnectionFactory();
		connectionFactory.setHost(this.configuration.getQueueConnectionHost());
		connection=connectionFactory.newConnection();

		for(int i=0;i<this.configuration.getMaxWorkerThreads();i++){
			T toLaunch=this.configuration.getHanlderClass().newInstance();
			toLaunch.bind(connection.createChannel(), this.configuration.getMessageRoutingKey());			
			toLaunch.start();
		}
		logger.debug("Initialization complete");
	}





	public void insertRequest(ExecutionRequest request) throws Exception{
		QueueSender sender=new QueueSender(connection.createChannel(), configuration.getMessageRoutingKey());
		sender.sendMessage(request);			
	}


}
