package org.gcube.data.harmonization.occurrence.operating;

import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.queue.QueueReceiver;

import com.j256.ormlite.dao.Dao;

public class OperatingModuleConfiguration<U extends ExecutionReference, T extends QueueReceiver> {

	private int maxWorkerThreads=1;
	private Dao<U,String> dao;
	private Class<T> hanlderClass;
	private String queueConnectionHost;
	private String messageRoutingKey;
	
	
	public OperatingModuleConfiguration() {
		// TODO Auto-generated constructor stub
	}


	/**
	 * @return the maxWorkerThreads
	 */
	public int getMaxWorkerThreads() {
		return maxWorkerThreads;
	}


	/**
	 * @param maxWorkerThreads the maxWorkerThreads to set
	 */
	public void setMaxWorkerThreads(int maxWorkerThreads) {
		this.maxWorkerThreads = maxWorkerThreads;
	}


	/**
	 * @return the dao
	 */
	public Dao<U, String> getDao() {
		return dao;
	}


	/**
	 * @param dao the dao to set
	 */
	public void setDao(Dao<U, String> dao) {
		this.dao = dao;
	}


	/**
	 * @return the hanlderClass
	 */
	public Class<T> getHanlderClass() {
		return hanlderClass;
	}


	/**
	 * @param hanlderClass the hanlderClass to set
	 */
	public void setHanlderClass(Class<T> hanlderClass) {
		this.hanlderClass = hanlderClass;
	}


	/**
	 * @return the queueConnectionHost
	 */
	public String getQueueConnectionHost() {
		return queueConnectionHost;
	}


	/**
	 * @param queueConnectionHost the queueConnectionHost to set
	 */
	public void setQueueConnectionHost(String queueConnectionHost) {
		this.queueConnectionHost = queueConnectionHost;
	}



	/**
	 * @return the messageRoutingKey
	 */
	public String getMessageRoutingKey() {
		return messageRoutingKey;
	}


	/**
	 * @param messageRoutingKey the messageRoutingKey to set
	 */
	public void setMessageRoutingKey(String messageRoutingKey) {
		this.messageRoutingKey = messageRoutingKey;
	}
	



}
