package org.gcube.data.harmonization.occurrence.queue;

import java.io.IOException;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference.ExecutionRequest;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.MessageProperties;
import com.thoughtworks.xstream.XStream;

public class QueueSender{
	
	private static GCUBELog logger = new GCUBELog(QueueSender.class);
	
	
	 private Channel channel;
	 
	 private String routingKey;
	 
	  
	 
	public QueueSender(Channel channel, String routingKey) throws IOException {
		super();
		this.channel = channel;
		this.routingKey = routingKey;
		this.channel.exchangeDeclare(getExchangeName(), "topic");
		this.channel.queueDeclare(getExchangeName(), true, false, false, null);		
	}

	public String getExchangeName(){
		 return ServiceContext.getContext().getName();
	}


	public void sendMessage(ExecutionRequest toSendMessage) throws IOException{			
		 channel.basicPublish(getExchangeName(), routingKey, MessageProperties.PERSISTENT_TEXT_PLAIN, 
				 new XStream().toXML(toSendMessage).getBytes());
		 logger.info("Sent Message "+toSendMessage+" to Routing Key :"+routingKey);
	 }
	
}
