/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.db.model;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionReference;
import org.gcube.data.harmonization.occurrence.db.model.ExecutionState;
import org.gcube.data.harmonization.occurrence.db.model.ImportReference;
import org.gcube.data.harmonization.occurrence.db.model.ToMergeImported;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;

@DatabaseTable
public class MergeReference
extends ExecutionReference {
    public static final String TO_MERGE_FIELD = "to_merge";
    public static final String MERGED_TABLE = "merged_table";
    @ForeignCollectionField(eager=false, columnName="to_merge")
    private ForeignCollection<ToMergeImported> toMergeImportedReferences;
    @DatabaseField(columnName="merged_table")
    private String mergedTable;

    public MergeReference(MergeRequest request) throws SQLException {
        super(request);
        this.setMergedTable(null);
        Dao<ImportReference, String> importDao = ServiceContext.getContext().getImportDao();
        Dao<ToMergeImported, Integer> relationDao = ServiceContext.getContext().getToMergeDao();
        Dao<MergeReference, String> mergeDao = ServiceContext.getContext().getMergeDao();
        try {
            logger.debug((Object)"Creating merge reference..");
            mergeDao.create((Object)this);
            logger.debug((Object)"Creating relations for merge");
            for (String importId : request.getToMergeIds()) {
                ToMergeImported relation = new ToMergeImported((ImportReference)importDao.queryForId((Object)importId), this);
                relationDao.create((Object)relation);
            }
            logger.debug((Object)"Merge Reference created");
        }
        catch (SQLException e) {
            logger.error((Object)"Something went wrong, cleaning references..");
            if (this.getToMergeImportedReferences() != null) {
                logger.debug((Object)("Deleted " + relationDao.delete(this.getToMergeImportedReferences()) + " relation rows"));
            }
            if (mergeDao.idExists((Object)this.getId())) {
                mergeDao.deleteById((Object)this.getId());
            }
            throw e;
        }
    }

    public MergeReference() {
    }

    public ForeignCollection<ToMergeImported> getToMergeImportedReferences() {
        return this.toMergeImportedReferences;
    }

    public void setToMergeImportedReferences(ForeignCollection<ToMergeImported> toMergeImportedReferences) {
        this.toMergeImportedReferences = toMergeImportedReferences;
    }

    public String getMergedTable() {
        return this.mergedTable;
    }

    public void setMergedTable(String mergedTable) {
        this.mergedTable = mergedTable;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void updateStatus(ExecutionState toSet) throws Exception {
        this.setState(toSet);
        if (toSet.equals((Object)ExecutionState.STARTED)) {
            this.setStartTime(System.currentTimeMillis());
        } else if (toSet.equals((Object)ExecutionState.COMPLETED) || toSet.equals((Object)ExecutionState.ERROR)) {
            this.setCompletionTime(System.currentTimeMillis());
        }
        ServiceContext.getContext().getMergeDao().update((Object)this);
    }

    public static class MergeRequest
    extends ExecutionReference.ExecutionRequest {
        private List<String> toMergeIds;

        public MergeRequest(GCUBEScope scope, String author, List<String> toMergeIds) {
            super(scope, author);
            this.toMergeIds = toMergeIds;
        }

        public List<String> getToMergeIds() {
            return this.toMergeIds;
        }
    }
}

