/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.db.model;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import org.gcube.data.harmonization.occurrence.db.model.ImportReference;
import org.gcube.data.harmonization.occurrence.db.model.MergeReference;
import org.gcube.data.harmonization.occurrence.services.ServiceContext;

@DatabaseTable
public class ToMergeImported
extends BaseDaoEnabled<ToMergeImported, String> {
    public static final String IMPORTED_ID = "import_id";
    public static final String MERGE_ID = "merge_id";
    @DatabaseField(foreign=true, columnName="import_id")
    private ImportReference importReference;
    @DatabaseField(foreign=true, columnName="merge_id")
    private MergeReference mergeReference;
    @DatabaseField(generatedId=true)
    private Integer id;

    public ToMergeImported() {
    }

    public ToMergeImported(ImportReference importReference, MergeReference mergeReference) {
        this.importReference = importReference;
        this.mergeReference = mergeReference;
    }

    public ImportReference getImportReference() {
        return this.importReference;
    }

    public void setImportReference(ImportReference importReference) {
        this.importReference = importReference;
    }

    public MergeReference getMergeReference() {
        return this.mergeReference;
    }

    public void setMergeReference(MergeReference mergeReference) {
        this.mergeReference = mergeReference;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ToMergeImported other = (ToMergeImported)((Object)obj);
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ToMergeImported [importReference=");
        builder.append(this.importReference);
        builder.append(", mergeReference=");
        builder.append(this.mergeReference);
        builder.append(", id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    public static PreparedQuery<MergeReference> getMergePerImportPreparedQuery() throws SQLException {
        QueryBuilder mergeImportQb = ServiceContext.getContext().getToMergeDao().queryBuilder();
        mergeImportQb.selectColumns(new String[]{MERGE_ID});
        mergeImportQb.where().eq(IMPORTED_ID, (Object)new SelectArg());
        QueryBuilder mergeQb = ServiceContext.getContext().getMergeDao().queryBuilder();
        mergeQb.where().in("id", mergeImportQb);
        return mergeQb.prepare();
    }

    public static PreparedQuery<ImportReference> getImportPerMergePreparedQuery() throws SQLException {
        QueryBuilder mergeImportQb = ServiceContext.getContext().getToMergeDao().queryBuilder();
        mergeImportQb.selectColumns(new String[]{IMPORTED_ID});
        mergeImportQb.where().eq(MERGE_ID, (Object)new SelectArg());
        QueryBuilder importQb = ServiceContext.getContext().getImportDao().queryBuilder();
        importQb.where().in("id", mergeImportQb);
        return importQb.prepare();
    }
}

