/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.stubs.SMAlgorithm;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationConfig;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputationRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMComputations;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMListGroupedAlgorithms;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameter;
import org.gcube.data.analysis.statisticalmanager.stubs.SMParameters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTypeParameter;
import org.gcube.data.harmonization.occurrence.OccurrenceStreamer;
import org.gcube.data.harmonization.occurrence.Reconciliation;
import org.gcube.data.harmonization.occurrence.impl.model.Computation;
import org.gcube.data.harmonization.occurrence.impl.model.Operation;
import org.gcube.data.harmonization.occurrence.impl.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.impl.model.Resource;
import org.gcube.data.harmonization.occurrence.impl.model.db.TableConnectionDescriptor;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.AlgorithmParameter;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalComputation;
import org.gcube.data.harmonization.occurrence.impl.model.statistical.StatisticalFeature;
import org.gcube.data.harmonization.occurrence.impl.model.types.DataType;
import org.gcube.data.harmonization.occurrence.impl.model.types.OperationType;
import org.gcube.data.harmonization.occurrence.impl.model.types.ResourceType;
import org.gcube.data.harmonization.occurrence.impl.model.types.Status;
import org.gcube.data.harmonization.occurrence.impl.readers.CSVParserConfiguration;
import org.gcube.data.harmonization.occurrence.impl.readers.OccurrenceReader;
import org.gcube.data.harmonization.occurrence.impl.readers.ParserConfiguration;
import org.gcube.data.harmonization.occurrence.impl.readers.XMLParserConfiguration;
import org.gcube.data.harmonization.occurrence.impl.readers.formats.CSVReader;
import org.gcube.data.harmonization.occurrence.impl.readers.formats.XMLReader;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.ResultWrapper;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.ComputationalAgentClass;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntries;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMEntry;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMOperation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class ReconciliationImpl
implements Reconciliation {
    private static final GCUBELog logger = new GCUBELog(ReconciliationImpl.class);
    private static SMTypeParameter DEFAULT_SMTYPE = new SMTypeParameter(StatisticalServiceType.TABULAR, new String[]{TableTemplates.OCCURRENCE_SPECIES.toString()});
    private GCUBEScope scope;
    private String user;
    private StatisticalManagerFactory factory;
    private StatisticalManagerDataSpace dataSpace;
    private TableConnectionDescriptor tableConn;

    public ReconciliationImpl(GCUBEScope scope, String user) {
        logger.trace((Object)("Scope is " + scope));
        this.scope = scope;
        this.user = user;
        ScopeProvider.instance.set(scope.toString());
        this.factory = (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().build();
        this.dataSpace = (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().build();
    }

    public ReconciliationImpl(GCUBEScope scope, String user, URI host) {
        logger.trace((Object)("Scope is " + scope));
        this.scope = scope;
        this.user = user;
        ScopeProvider.instance.set(scope.toString());
        this.factory = (StatisticalManagerFactory)StatisticalManagerDSL.createStateful().at(host).build();
        this.dataSpace = (StatisticalManagerDataSpace)StatisticalManagerDSL.dataSpace().at(host).build();
    }

    @Override
    public List<Resource> getDataSets() {
        SMComputations computationList;
        int n;
        ScopeProvider.instance.set(this.scope.toString());
        ArrayList<Resource> toReturn = new ArrayList<Resource>();
        SMImporters importersList = this.dataSpace.getImporters(this.user, TableTemplates.OCCURRENCE_SPECIES.toString());
        if (importersList != null && importersList.getList() != null) {
            SMImport[] sMImportArray = importersList.getList();
            n = sMImportArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMImport importRef = sMImportArray[n2];
                if (Status.values()[importRef.getOperationStatus()].equals((Object)Status.COMPLETED)) {
                    try {
                        Resource toAdd = ReconciliationImpl.operationToResource((SMOperation)importRef);
                        toAdd.getOperation().setOperationType(OperationType.IMPORT);
                        toReturn.add(toAdd);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to get resource information for importRef " + importRef.getOperationId()));
                        logger.debug((Object)"Exception was ", (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        if ((computationList = this.factory.getComputations(this.user, new SMTypeParameter[]{DEFAULT_SMTYPE})) != null && computationList.getList() != null) {
            SMComputation[] sMComputationArray = computationList.getList();
            int n3 = sMComputationArray.length;
            n = 0;
            while (n < n3) {
                SMComputation comp = sMComputationArray[n];
                if (Status.values()[comp.getOperationStatus()].equals((Object)Status.COMPLETED)) {
                    try {
                        Resource toAdd = ReconciliationImpl.operationToResource((SMOperation)comp);
                        toAdd.getOperation().setOperationType(OperationType.COMPUTATION);
                        toReturn.add(toAdd);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to get resource information for comp " + comp.getOperationId()));
                        logger.debug((Object)"Exception was ", (Throwable)e);
                    }
                }
                ++n;
            }
        }
        return toReturn;
    }

    @Override
    public String getJSONImported(PagedRequestSettings settings) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        if (this.tableConn == null) {
            throw new Exception("Table connection not opened");
        }
        return this.tableConn.getJSON(settings);
    }

    @Override
    public List<StatisticalFeature> getCapabilities() {
        ScopeProvider.instance.set(this.scope.toString());
        ArrayList<StatisticalFeature> toReturn = new ArrayList<StatisticalFeature>();
        SMListGroupedAlgorithms list = this.factory.getAlgorithms(new SMTypeParameter[]{DEFAULT_SMTYPE});
        if (list != null && list.getList() != null) {
            SMGroupedAlgorithms[] sMGroupedAlgorithmsArray = list.getList();
            int n = sMGroupedAlgorithmsArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMGroupedAlgorithms groupedAlg = sMGroupedAlgorithmsArray[n2];
                if (groupedAlg != null && groupedAlg.getList() != null) {
                    ComputationalAgentClass category = groupedAlg.getCategory();
                    SMAlgorithm[] sMAlgorithmArray = groupedAlg.getList();
                    int n3 = sMAlgorithmArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        SMAlgorithm algorithm = sMAlgorithmArray[n4];
                        StatisticalFeature feature = new StatisticalFeature();
                        SMParameters foundParams = this.factory.getAlgorithmParameters(category, algorithm.getName());
                        ArrayList<AlgorithmParameter> params = new ArrayList<AlgorithmParameter>();
                        if (foundParams != null && foundParams.getList() != null) {
                            SMParameter[] sMParameterArray = foundParams.getList();
                            int n5 = sMParameterArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                SMParameter param = sMParameterArray[n6];
                                params.add(new AlgorithmParameter(new DataType(Arrays.asList(param.getType().getValues()), DataType.Type.valueOf("" + param.getType().getName())), param.getName(), param.getDefaultValue(), param.getDescription()));
                                ++n6;
                            }
                        }
                        feature.setComputation(new StatisticalComputation(algorithm.getName(), algorithm.getDescription(), category.getValue()));
                        feature.setParameters(params);
                        toReturn.add(feature);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return toReturn;
    }

    @Override
    public File getResourceAsFile(String operationId, OperationType type) throws Exception {
        SMImport operation = null;
        switch (type) {
            case IMPORT: {
                operation = this.dataSpace.getImporter(operationId);
                break;
            }
            case COMPUTATION: {
                operation = this.factory.getComputation(operationId);
                break;
            }
            default: {
                throw new Exception("Invalid Operation Type " + (Object)((Object)type));
            }
        }
        Status status = Status.values()[operation.getOperationStatus()];
        if (!status.equals((Object)Status.COMPLETED)) {
            throw new Exception("Operation not completed, status is " + (Object)((Object)status));
        }
        Resource resource = ReconciliationImpl.operationToResource((SMOperation)operation);
        if (!resource.getType().equals((Object)ResourceType.TABULAR)) {
            throw new Exception("Unexpected Resource Type " + (Object)((Object)resource.getType()));
        }
        return this.saveTable(resource);
    }

    @Override
    public String submitOperation(StatisticalComputation comp, Map<String, String> parameters, String title, String description) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        SMComputationConfig config = new SMComputationConfig();
        config.setAlgorithm(new SMAlgorithm(comp.getCategory(), comp.getDescription(), comp.getAlgorithm()));
        ArrayList<SMEntry> entries = new ArrayList<SMEntry>();
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            entries.add(new SMEntry(0L, 0L, param.getKey(), param.getValue()));
        }
        config.setParameters(new SMEntries(entries.toArray(new SMEntry[entries.size()])));
        SMComputationRequest request = new SMComputationRequest();
        request.setConfig(config);
        request.setDescription(description);
        request.setTitle(title);
        request.setUser(this.user);
        return this.factory.executeComputation(request);
    }

    @Override
    public List<Computation> getSubmittedOperationList() {
        ScopeProvider.instance.set(this.scope.toString());
        ArrayList<Computation> toReturn = new ArrayList<Computation>();
        ArrayList<SMTypeParameter> types = new ArrayList<SMTypeParameter>();
        types.add(DEFAULT_SMTYPE);
        SMComputations computationList = this.factory.getComputations(this.user, new SMTypeParameter[]{DEFAULT_SMTYPE});
        if (computationList != null && computationList.getList() != null) {
            SMComputation[] sMComputationArray = computationList.getList();
            int n = sMComputationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMComputation comp = sMComputationArray[n2];
                toReturn.add(ReconciliationImpl.translate(comp));
                ++n2;
            }
        }
        return toReturn;
    }

    @Override
    public synchronized List<String> openTableInspection(String tableId) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        if (this.tableConn != null) {
            this.tableConn.close();
        }
        this.tableConn = new TableConnectionDescriptor(this.dataSpace.getDBParameters(tableId), tableId);
        return this.tableConn.getColumns();
    }

    @Override
    public synchronized void closeTableConnection() throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        if (this.tableConn != null) {
            this.tableConn.close();
        }
        this.tableConn = null;
    }

    @Override
    public OccurrenceStreamer getStreamer(File toStream, ParserConfiguration configuration, String tableName, String description) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        OccurrenceReader streamer = null;
        if (configuration instanceof XMLParserConfiguration) {
            streamer = new XMLReader(toStream, (XMLParserConfiguration)configuration);
        } else if (configuration instanceof CSVParserConfiguration) {
            streamer = new CSVReader(toStream, (CSVParserConfiguration)configuration);
        }
        if (streamer == null) {
            throw new Exception("Invalid passed configuration");
        }
        ResultWrapper wrapper = new ResultWrapper(this.scope);
        streamer.setWrapper((ResultWrapper<OccurrencePoint>)wrapper);
        PipedStream stream = Streams.pipe((Stream)Streams.convert((URI)new URI(wrapper.getLocator())).of(GenericRecord.class).withDefaults()).through((Generator)new ResultGenerator());
        String dataID = this.dataSpace.createTableFromDataStream((Stream)stream, tableName, description, this.user);
        logger.info((Object)("Streaming to resource ID " + dataID));
        return streamer;
    }

    @Override
    public String getTableUrl(String tableId) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        return this.dataSpace.getDBParameters(tableId);
    }

    @Override
    public void removeComputationById(String id) throws Exception {
        ScopeProvider.instance.set(this.scope.toString());
        this.factory.removeComputation(id);
    }

    private static final Resource operationToResource(SMOperation op) throws Exception {
        Resource toReturn = new Resource();
        toReturn.setId(op.getAbstractResource().getResource().getResourceId());
        toReturn.setName(op.getAbstractResource().getResource().getName());
        toReturn.setResourceDescription(op.getAbstractResource().getResource().getDescription());
        toReturn.setType(ResourceType.values()[op.getAbstractResource().getResource().getResourceType()]);
        toReturn.setOperation(ReconciliationImpl.translate(op));
        return toReturn;
    }

    private static final Computation translate(SMComputation comp) {
        Computation toReturn = new Computation();
        toReturn.setCompletionDate(comp.getCompletedDate());
        toReturn.setOperationDescription(comp.getDescription());
        toReturn.setOperationId(comp.getOperationId());
        toReturn.setStatus(Status.values()[comp.getOperationStatus()]);
        toReturn.setSubmissionDate(comp.getSubmissionDate());
        toReturn.setAlgorithm(comp.getAlgorithm());
        toReturn.setCategory(comp.getCategory());
        toReturn.setTitle(comp.getTitle());
        HashMap<String, String> params = new HashMap<String, String>();
        if (comp.getParameters() != null) {
            SMEntry[] sMEntryArray = comp.getParameters();
            int n = sMEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                SMEntry entry = sMEntryArray[n2];
                params.put(entry.getKey(), entry.getValue());
                ++n2;
            }
        }
        toReturn.setParameters(params);
        toReturn.setOperationType(OperationType.COMPUTATION);
        return toReturn;
    }

    private static final Operation translate(SMOperation op) {
        Operation toReturn = new Operation();
        toReturn.setCompletionDate(op.getCompletedDate());
        toReturn.setOperationDescription(op.getDescription());
        toReturn.setOperationId(op.getOperationId());
        toReturn.setStatus(Status.values()[op.getOperationStatus()]);
        toReturn.setSubmissionDate(op.getSubmissionDate());
        return toReturn;
    }

    private File saveTable(Resource toSave) throws Exception {
        File file;
        FileWriter writer;
        block7: {
            Connection conn = null;
            writer = null;
            try {
                logger.debug((Object)("Saveing resource " + toSave));
                String connectionUrl = this.dataSpace.getDBParameters(toSave.getId());
                logger.debug((Object)("Connecting to " + connectionUrl));
                conn = DriverManager.getConnection(connectionUrl);
                CopyManager manager = new CopyManager((BaseConnection)conn);
                File toReturn = File.createTempFile("SMResource", ".csv");
                writer = new FileWriter(toReturn);
                long count = manager.copyOut("COPY " + toSave.getId() + " TO STDOUT WITH DELIMITER ',' CSV HEADER ", (Writer)writer);
                logger.debug((Object)("Wrote " + count + " to " + toReturn.getAbsolutePath()));
                file = toReturn;
                if (conn == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        conn.close();
                    }
                    if (writer != null) {
                        IOUtils.closeQuietly(writer);
                    }
                    throw throwable;
                }
            }
            conn.close();
        }
        if (writer != null) {
            IOUtils.closeQuietly((Writer)writer);
        }
        return file;
    }
}

