/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence.impl.readers.formats;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.csv4j.CSVLineProcessor;
import org.apache.commons.io.input.CountingInputStream;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.harmonization.occurrence.impl.readers.CSVParserConfiguration;
import org.gcube.data.harmonization.occurrence.impl.readers.StreamProgress;
import org.gcube.data.harmonization.occurrence.impl.readers.formats.OccurrencePointFields;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.ResultWrapper;

public class OccurrenceCSVProcessor
implements CSVLineProcessor {
    protected static final SimpleDateFormat FORMAT = new SimpleDateFormat("MM/dd/yy KK:mm:ss a");
    private static final GCUBELog logger = new GCUBELog(OccurrenceCSVProcessor.class);
    private Map<OccurrencePointFields, Integer> mapping = new HashMap<OccurrencePointFields, Integer>();
    private ResultWrapper<OccurrencePoint> wrapper;
    private StreamProgress progress;
    private CSVParserConfiguration config;
    private CountingInputStream cis;
    private long pointCount = 0L;

    public OccurrenceCSVProcessor(ResultWrapper<OccurrencePoint> wrapper, StreamProgress progress, CSVParserConfiguration config, CountingInputStream cis) {
        this.wrapper = wrapper;
        this.progress = progress;
        this.config = config;
        this.cis = cis;
    }

    public boolean continueProcessing() {
        return !this.progress.getState().equals((Object)StreamProgress.OperationState.FAILED);
    }

    public void processDataLine(int arg0, List<String> arg1) {
        OccurrencePoint point = new OccurrencePoint("");
        point.setDataSet(new DataSet(""));
        point.getDataSet().setDataProvider(new DataProvider(""));
        block43: for (Map.Entry<OccurrencePointFields, Integer> entry : this.mapping.entrySet()) {
            String columnValue = arg1.get(entry.getValue());
            switch (entry.getKey()) {
                case BASIS_OF_RECORD: {
                    try {
                        point.setBasisOfRecord(BasisOfRecord.valueOf((String)columnValue));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to evaluate basis of record : " + columnValue));
                    }
                    continue block43;
                }
                case CATALOGUE_NUMBER: {
                    point.setCatalogueNumber(columnValue);
                    break;
                }
                case CITATION: {
                    point.setCitation(columnValue);
                    break;
                }
                case COLLECTION_CODE: {
                    point.setCollectionCode(columnValue);
                    break;
                }
                case COORDINATE_UNCERTAINTY_IN_METERS: {
                    point.setCoordinateUncertaintyInMeters(columnValue);
                    break;
                }
                case COUNTRY: {
                    point.setCountry(columnValue);
                    break;
                }
                case DATA_PROVIDER_ID: {
                    break;
                }
                case DATA_PROVIDER_NAME: {
                    point.getDataSet().getDataProvider().setName(columnValue);
                    break;
                }
                case DATA_SET_CITATION: {
                    break;
                }
                case DATA_SET_ID: {
                    break;
                }
                case DATA_SET_NAME: {
                    point.getDataSet().setName(columnValue);
                    break;
                }
                case DECIMAL_LATITUDE: {
                    try {
                        point.setDecimalLatitude(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse decimal latitude " + columnValue));
                    }
                    continue block43;
                }
                case DECIMAL_LONGITUDE: {
                    try {
                        point.setDecimalLongitude(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse decimal longitude " + columnValue));
                    }
                    continue block43;
                }
                case EVENT_DATE: {
                    Calendar calendar;
                    Date date;
                    try {
                        date = FORMAT.parse(columnValue);
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        point.setEventDate(calendar);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to parse event date : " + columnValue));
                    }
                    continue block43;
                }
                case FAMILY: {
                    point.setFamily(columnValue);
                    break;
                }
                case ID: {
                    point.setId(columnValue);
                    break;
                }
                case INSTITUTION_CODE: {
                    point.setInstitutionCode(columnValue);
                    break;
                }
                case KINGDOM: {
                    point.setKingdom(columnValue);
                    break;
                }
                case LOCALITY: {
                    point.setLocality(columnValue);
                    break;
                }
                case MAX_DEPTH: {
                    try {
                        point.setMaxDepth(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse max depth " + columnValue));
                    }
                    continue block43;
                }
                case MIN_DEPTH: {
                    try {
                        point.setMinDepth(Double.parseDouble(columnValue));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("Unable to parse min depth " + columnValue));
                    }
                    continue block43;
                }
                case MODIFIED: {
                    Calendar calendar;
                    Date date;
                    try {
                        date = FORMAT.parse(columnValue);
                        calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        point.setModified(calendar);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to parse modified: " + columnValue));
                    }
                    continue block43;
                }
                case PROVIDER: {
                    point.setProvider(columnValue);
                    break;
                }
                case RECORDED_BY: {
                    point.setRecordedBy(columnValue);
                    break;
                }
                case SCIENTIFIC_NAME: {
                    point.setScientificName(columnValue);
                }
            }
        }
        try {
            this.wrapper.add((Object)point);
            this.progress.setElaboratedLenght(this.cis.getCount());
            System.out.println(this.pointCount++);
        }
        catch (Exception e) {
            this.progress.setFailureReason("Unable to stream data");
            this.progress.setFailureDetails(e.getMessage());
            this.progress.setState(StreamProgress.OperationState.FAILED);
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        String s;
        int i = 0;
        while (i < arg1.size()) {
            if (this.config.getFieldMap()[i]) {
                s = arg1.get(i);
                if (s.equals("#id")) {
                    this.mapping.put(OccurrencePointFields.ID, i);
                } else if (s.equals("label")) {
                    this.mapping.put(OccurrencePointFields.SCIENTIFIC_NAME, i);
                } else if (s.equals("long")) {
                    this.mapping.put(OccurrencePointFields.DECIMAL_LONGITUDE, i);
                } else if (s.equals("lat")) {
                    this.mapping.put(OccurrencePointFields.DECIMAL_LATITUDE, i);
                }
            }
            ++i;
        }
        if (this.mapping.size() != 4) {
            i = 0;
            while (i < arg1.size()) {
                if (this.config.getFieldMap()[i]) {
                    s = arg1.get(i);
                    if (s.equals("institutionCode")) {
                        this.mapping.put(OccurrencePointFields.INSTITUTION_CODE, i);
                    } else if (s.equals("collectionCode")) {
                        this.mapping.put(OccurrencePointFields.COLLECTION_CODE, i);
                    } else if (s.equals("catalogueNumber")) {
                        this.mapping.put(OccurrencePointFields.CATALOGUE_NUMBER, i);
                    } else if (s.equals("dataSet")) {
                        this.mapping.put(OccurrencePointFields.DATA_SET_NAME, i);
                    } else if (s.equals("dataProvider")) {
                        this.mapping.put(OccurrencePointFields.DATA_PROVIDER_NAME, i);
                    } else if (s.equals("dataSource")) {
                        this.mapping.put(OccurrencePointFields.PROVIDER, i);
                    } else if (s.equals("recordedBy")) {
                        this.mapping.put(OccurrencePointFields.RECORDED_BY, i);
                    } else if (s.equals("eventDate")) {
                        this.mapping.put(OccurrencePointFields.EVENT_DATE, i);
                    } else if (s.equals("modified")) {
                        this.mapping.put(OccurrencePointFields.MODIFIED, i);
                    } else if (s.equals("scientificName")) {
                        this.mapping.put(OccurrencePointFields.SCIENTIFIC_NAME, i);
                    } else if (s.equals("kingdom")) {
                        this.mapping.put(OccurrencePointFields.KINGDOM, i);
                    } else if (s.equals("family")) {
                        this.mapping.put(OccurrencePointFields.FAMILY, i);
                    } else if (s.equals("locality")) {
                        this.mapping.put(OccurrencePointFields.LOCALITY, i);
                    } else if (s.equals("country")) {
                        this.mapping.put(OccurrencePointFields.COUNTRY, i);
                    } else if (s.equals("citation")) {
                        this.mapping.put(OccurrencePointFields.CITATION, i);
                    } else if (s.equals("decimalLatitude")) {
                        this.mapping.put(OccurrencePointFields.DECIMAL_LATITUDE, i);
                    } else if (s.equals("decimalLongitude")) {
                        this.mapping.put(OccurrencePointFields.DECIMAL_LONGITUDE, i);
                    } else if (s.equals("coordinateUncertaintyInMeters")) {
                        this.mapping.put(OccurrencePointFields.COORDINATE_UNCERTAINTY_IN_METERS, i);
                    } else if (s.equals("maxDepth")) {
                        this.mapping.put(OccurrencePointFields.MAX_DEPTH, i);
                    } else if (s.equals("minDepth")) {
                        this.mapping.put(OccurrencePointFields.MIN_DEPTH, i);
                    } else if (s.equals("basisOfRecord")) {
                        this.mapping.put(OccurrencePointFields.BASIS_OF_RECORD, i);
                    }
                }
                ++i;
            }
            if (this.mapping.size() != 21) {
                this.progress.setFailureReason("Unable to understand model");
                this.progress.setFailureDetails("");
                this.progress.setState(StreamProgress.OperationState.FAILED);
            }
        }
    }
}

