package org.gcube.data.harmonization.occurrence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDSL;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpace;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerDataSpaceImporter;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerFactory;
import org.gcube.data.analysis.statisticalmanager.proxies.StatisticalManagerService;
import org.gcube.data.harmonization.occurrence.model.ImportedOccurrenceSet;
import org.gcube.data.harmonization.occurrence.model.PagedRequestSettings;
import org.gcube.data.harmonization.occurrence.model.SubmittedOperation;
import org.gcube.data.harmonization.occurrence.model.db.TableConnectionDescriptor;
import org.gcube.data.harmonization.occurrence.model.statistical.StatisticalOperation;
import org.gcube.data.harmonization.occurrence.model.statistical.StatisticalParameter;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Feature;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.Features;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMComputation;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTableMetadata;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTypeParameter;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StatisticalServiceType;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.StringValues;

public class ReconciliationImpl implements Reconciliation{
	
	private static final GCUBELog logger=new GCUBELog(ReconciliationImpl.class);
	
	
	private GCUBEScope scope;
	private String user;
	private StatisticalManagerService service;
	private StatisticalManagerFactory factory;
	private StatisticalManagerDataSpace dataSpace;
	private StatisticalManagerDataSpaceImporter importer;
	private TableConnectionDescriptor tableConn;
	
	
	public ReconciliationImpl(GCUBEScope scope,String user) {
		logger.trace("Scope is "+scope);
		this.scope=scope;
		this.user=user;
		ScopeProvider.instance.set(scope.toString());
		
		factory = StatisticalManagerDSL.createStateful().build();
		
		W3CEndpointReference address = factory.serviceConnect(user);
		
		service= StatisticalManagerDSL.stateful().at(address).build();
		
		dataSpace=StatisticalManagerDSL.dataSpace().build();
		
	}
	
	
	@Override
	public String importOccurrenceFromWorkspace(String fileId) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<ImportedOccurrenceSet> getImportedList() {
		ArrayList<ImportedOccurrenceSet> toReturn=new ArrayList<ImportedOccurrenceSet>();
		for(SMTableMetadata meta:dataSpace.getTableMetadata(user).getList()){
			toReturn.add(new ImportedOccurrenceSet(meta.getName(), meta.getId(), meta.getCreationDate(), meta.getDescription()));
		}
		return toReturn;
	}

	@Override
	public String getJSONImported(PagedRequestSettings settings)throws Exception {
		if(tableConn==null) throw new Exception("Table connection not opened");
		return tableConn.getJSON(settings);
	}

	@Override
	public List<StatisticalOperation> getCapabilities() {
		String[] template = {TableTemplates.OCCURRENCE_SPECIES.toString()};
		StringValues values = new StringValues(template);
    	ArrayList<StatisticalOperation> toReturn=new ArrayList<StatisticalOperation>();
    	
		Features features = factory.getFeaturesForInputParameters(new SMTypeParameter(StatisticalServiceType.TABULAR,
    			values));
		
		for(Feature f:features.getList()){
			// every feature has multiple algorithms
			for(String algorithm : f.getAlgorithms()){
				// request parameters for every computation
				SMComputation computation=new SMComputation(algorithm, f.getCategory(), "");
				ArrayList<StatisticalParameter> params=new ArrayList<StatisticalParameter>();
				for(SMParameter param:factory.getAlgorithmParameters(computation).getList()){
					params.add(new StatisticalParameter(param.getType().getName()+"", param.getName(), param.getDefaultValue(), param.getDescription()));
				}
				toReturn.add(new StatisticalOperation(params, algorithm, f.getCategory()+"", "")); 
			}
		}
		
		return toReturn;
	}

	@Override
	public void getResult(String operationId) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String saveResultToWorkspace(String operationId) {
		return null;
	}

	@Override
	public String submitUnaryOperation(String importedId, String operation,
			Map<String, String> parameters) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<SubmittedOperation> getSubmittedOperationList() {
		return null;
	}


	@Override
	public synchronized List<String> openTableInspection(String tableId) throws Exception {
		if(tableConn!=null) tableConn.close();
		tableConn=new TableConnectionDescriptor(dataSpace.getDBParameters(tableId), tableId);
		return tableConn.getColumns();
	}


	@Override
	public synchronized void closeTableConnection() throws Exception {
		if(tableConn!=null) tableConn.close();
		tableConn=null;
	}

	
	
	
	
	
}
