/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.harmonization.occurrence;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class Utils {
    public static String toJSon(ResultSet resultSet, Long count) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int row = 0;
        while (resultSet.next()) {
            if (row > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            int column = 1;
            while (column <= numberOfColumns) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(Utils.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(Utils.quote(resultSet.getString(column)));
                ++column;
            }
            json.append('}');
            ++row;
        }
        json.append("],\"totalcount\":");
        json.append(count);
        json.append("}");
        return json.toString();
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }
}

