/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin.binders;

import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.OAIException;
import org.gcube.common.OAIRecord;
import org.gcube.data.oai.tmplugin.Constants;
import org.gcube.data.oai.tmplugin.RepositoryProvider;
import org.gcube.data.oai.tmplugin.Utils;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OAIDCBinder
implements Serializable {
    private static final long serialVersionUID = -8037198825787888863L;
    private static final Logger log = LoggerFactory.getLogger(OAIDCBinder.class);
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private Request request;

    public OAIDCBinder(Request req) {
        this.request = req;
    }

    public OAIDCBinder(RepositoryProvider p) {
    }

    public Tree bind(OAIRecord record) throws Exception {
        try {
            Object mEdge;
            Tree tree = new Tree(record.getIdentifier());
            StringWriter writer = new StringWriter();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(record.getMetadata()), new StreamResult(writer));
            String metadata = writer.toString();
            Document metadataDocument = factory.newDocumentBuilder().parse(new InputSource(new StringReader(metadata)));
            try {
                mEdge = this.createBaseInfoEdge(record, tree, metadataDocument);
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createMetadataEdge(metadataDocument, record.getMetadataPrefix(), record.getMetadataNamespaceURI());
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createMainContentEdge(record, tree, metadataDocument);
                tree.add(mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            try {
                mEdge = this.createAlternativeContentEdge(tree, metadataDocument);
                tree.add((List)mEdge);
            }
            catch (Exception te) {
                log.warn("error retrieving the metadata", (Throwable)te);
            }
            return tree;
        }
        catch (Exception e) {
            log.error("could not convert record:" + record.getIdentifier(), (Throwable)e);
            throw new Exception("could not convert record", e);
        }
    }

    private List<Edge> createBaseInfoEdge(OAIRecord record, Tree tree, Document metadataDocument) throws Exception {
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        try {
            Edge titleEdge = Nodes.e((String)"title", (Object)"");
            if (this.request.getTitleXPath() != null) {
                try {
                    XPathFactory xpathFactory = XPathFactory.newInstance();
                    XPath xPath = xpathFactory.newXPath();
                    NodeList nl = (NodeList)xPath.evaluate(this.request.getTitleXPath(), metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) != null) {
                        String recordName = nl.item(0).getTextContent();
                        titleEdge = Nodes.e((String)"title", (Object)recordName);
                    }
                }
                catch (Exception e) {
                    log.warn("cannot calculate the title of " + tree.id(), (Throwable)e);
                }
            }
            edgeList.add(titleEdge);
            Edge setEdge = Nodes.e((String)"collectionID", (Object)"");
            try {
                setEdge = Nodes.e((String)"collectionID", (Object)record.getSetSpec());
            }
            catch (OAIException e) {
                log.warn("cannot create setEdge", (Throwable)e);
            }
            edgeList.add(setEdge);
            Calendar timestamp = null;
            try {
                timestamp = Constants.getDate(record.getDatestamp());
            }
            catch (OAIException e1) {
                log.warn("cannot caluculate", (Object)timestamp);
            }
            Edge creationTimeEdge = Nodes.e((String)"creationTime", (Object)timestamp);
            edgeList.add(creationTimeEdge);
            Edge lastUpdateTimeEdge = Nodes.e((String)"lastUpdateTime", (Object)timestamp);
            edgeList.add(lastUpdateTimeEdge);
            Edge provenanceEdge = Nodes.e((String)"provenance", (Object)"");
            try {
                List<Edge> provenanceEdgeList = this.createProvenanceEdge(record);
                provenanceEdge = Nodes.e((String)"provenance", (Node)Nodes.n((Edge[])provenanceEdgeList.toArray(new Edge[0])));
                edgeList.add(provenanceEdge);
            }
            catch (Exception e) {
                log.warn("cannot create  provenance Edge ", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new Exception("could not create BaseInfo Edge ", e);
        }
        return edgeList;
    }

    private List<Edge> createProvenanceEdge(OAIRecord record) throws OAIException {
        String provenance = "This item has been created by the gCube OAI-TM plugin via OAI-PMH metadata harvesting from the metadata provider " + this.request.getName() + " at " + this.request.getRepositoryUrl();
        ArrayList<Edge> provenanceEdgeList = new ArrayList<Edge>();
        provenanceEdgeList.add(Nodes.e((String)"statement", (Object)provenance));
        int i = 0;
        while (i < record.getSetSpeList().size()) {
            provenanceEdgeList.add(Nodes.e((String)"setID", record.getSetSpeList().get(i)));
            ++i;
        }
        provenanceEdgeList.add(Nodes.e((String)"recordID", (Object)record.getIdentifier()));
        return provenanceEdgeList;
    }

    private Edge createMetadataEdge(Document metadataDocument, String schema, String schemaLocation) throws Exception {
        Edge metadataEdge = this.createTreeByMetadata(metadataDocument);
        return Nodes.e((String)"metadata", (Node)new InnerNode(new Edge[]{Nodes.e((String)"schema", (Object)schema), Nodes.e((String)"schemaLocation", (Object)schemaLocation), metadataEdge}));
    }

    private Edge createTreeByMetadata(Document doc) {
        Edge metadataEdge = Nodes.e((String)"record", (Object)"");
        try {
            Edge edge = this.printNodeInfo(doc.getDocumentElement(), null);
            metadataEdge = Nodes.e((String)"record", (Node)new InnerNode(new Edge[]{edge}));
        }
        catch (Exception e) {
            log.error("error creating TreeByMetadata", (Throwable)e);
        }
        return metadataEdge;
    }

    public Edge printNodeInfo(org.w3c.dom.Node currentNode, Edge edge) {
        short sNodeType = currentNode.getNodeType();
        String sNodeName = null;
        ArrayList<Edge> edges = new ArrayList<Edge>();
        if (sNodeType == 1) {
            sNodeName = currentNode.getNodeName();
            String sNodeValue = OAIDCBinder.searchTextInElement(currentNode);
            if (sNodeValue != null) {
                if (!sNodeValue.trim().equalsIgnoreCase("")) {
                    edge = Nodes.e((String)sNodeName, (Object)sNodeValue);
                } else if (!currentNode.hasChildNodes()) {
                    edge = Nodes.e((String)sNodeName, (Object)"");
                }
            }
            int iChildNumber = currentNode.getChildNodes().getLength();
            if (currentNode.hasChildNodes()) {
                NodeList nlChilds = currentNode.getChildNodes();
                int iChild = 0;
                while (iChild < iChildNumber) {
                    if (nlChilds.item(iChild).getNodeType() == 1) {
                        edges.add(this.printNodeInfo(nlChilds.item(iChild), null));
                    }
                    ++iChild;
                }
            }
        }
        if (edges.size() > 0) {
            InnerNode innerNode = new InnerNode(edges.toArray(new Edge[0]));
            edge = Nodes.e((String)sNodeName, (Node)innerNode);
        }
        NamedNodeMap nnmAttributes = currentNode.getAttributes();
        OAIDCBinder.setAttributes(nnmAttributes, edge.target());
        return edge;
    }

    private static String searchTextInElement(org.w3c.dom.Node elementNode) {
        String sText = "";
        if (elementNode.hasChildNodes()) {
            org.w3c.dom.Node nTextChild = elementNode.getChildNodes().item(0);
            sText = nTextChild.getNodeValue();
        }
        return sText;
    }

    private static boolean setAttributes(NamedNodeMap nnm, Node node) {
        if (nnm != null && nnm.getLength() > 0) {
            int iAttr = 0;
            while (iAttr < nnm.getLength()) {
                String name = nnm.item(iAttr).getNodeName();
                String value = nnm.item(iAttr).getNodeValue();
                node.setAttribute(name, value);
                ++iAttr;
            }
            return true;
        }
        return false;
    }

    private Edge createMainContentEdge(OAIRecord record, Tree tree, Document metadataDocument) throws Exception {
        Edge urlEdge;
        Edge mimeTypeEdge;
        Edge contentTypeEdge;
        block6: {
            contentTypeEdge = Nodes.e((String)"contentType", (Object)"");
            mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"");
            urlEdge = Nodes.e((String)"url", (Object)"");
            try {
                if (this.request.getContentXPath() == null) break block6;
                try {
                    contentTypeEdge = Nodes.e((String)"contentType", (Object)"main");
                    XPathFactory factory = XPathFactory.newInstance();
                    XPath xPath = factory.newXPath();
                    NodeList nl = (NodeList)xPath.evaluate(this.request.getContentXPath(), metadataDocument, XPathConstants.NODESET);
                    if (nl.item(0) == null) break block6;
                    String contentUri = nl.item(0).getTextContent();
                    String url = Utils.resolver(contentUri);
                    try {
                        mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"text/url");
                    }
                    catch (Exception e) {
                        log.warn("could not retrieve mime type for " + record.getIdentifier());
                    }
                    urlEdge = Nodes.e((String)"url", (Object)url);
                }
                catch (Throwable e) {
                    log.error("could not retrieve content for " + tree.id(), e);
                }
            }
            catch (Exception e) {
                throw new Exception("could not create MainContent Edge ", e);
            }
        }
        return Nodes.e((String)"content", (Node)new InnerNode(new Edge[]{contentTypeEdge, mimeTypeEdge, urlEdge}));
    }

    private List<Edge> createAlternativeContentEdge(Tree tree, Document metadataDocument) throws Exception {
        List<Edge> edgeList = new ArrayList<Edge>();
        try {
            int i = 0;
            while (i < this.request.getAlternativesXPath().size()) {
                String path = this.request.getAlternativesXPath().get(i);
                try {
                    edgeList = this.createAlternatives(i, path, metadataDocument);
                }
                catch (Exception te) {
                    log.warn("could not retrieve alternatives in " + tree.id() + " with path " + path, (Throwable)te);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("could not create AlternativeContent Edge ", e);
        }
        return edgeList;
    }

    private List<Edge> createAlternatives(int identifier, String path, Document metadataDocument) throws Exception {
        ArrayList<Edge> edgeList = null;
        try {
            edgeList = new ArrayList<Edge>();
            XPathFactory factory = XPathFactory.newInstance();
            XPath xPath = factory.newXPath();
            NodeList nl = (NodeList)xPath.evaluate(path, metadataDocument, XPathConstants.NODESET);
            int i = 0;
            while (i < nl.getLength()) {
                Edge contentTypeEdge = Nodes.e((String)"contentType", (Object)"alternative");
                String alternativeUri = "";
                try {
                    alternativeUri = nl.item(i).getTextContent();
                    Edge mimeTypeEdge = Nodes.e((String)"mimeType", (Object)"none");
                    URI uri = new URI(alternativeUri);
                    URLConnection urlConnection = null;
                    urlConnection = uri.toURL().openConnection();
                    mimeTypeEdge = Nodes.e((String)"mimeType", (Object)urlConnection.getContentType());
                    edgeList.add(Nodes.e((String)"content", (Node)Nodes.n((Edge[])new Edge[]{contentTypeEdge, mimeTypeEdge, Nodes.e((String)"url", (Object)alternativeUri)})));
                }
                catch (Exception e) {
                    log.warn("impossible to retrieve alternative, maybe the URI has an illegal characters: " + alternativeUri);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("could not create Alternatives ", e);
        }
        return edgeList;
    }
}

